/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.eventhubs.core.listener;

import com.azure.messaging.eventhubs.EventProcessorClient;
import com.azure.spring.cloud.service.eventhubs.consumer.EventHubsErrorHandler;
import com.azure.spring.cloud.service.listener.MessageListener;
import com.azure.spring.messaging.eventhubs.core.EventHubsProcessorFactory;
import com.azure.spring.messaging.eventhubs.core.properties.EventHubsContainerProperties;
import com.azure.spring.messaging.listener.AbstractMessageListenerContainer;

public class EventHubsMessageListenerContainer
extends AbstractMessageListenerContainer {
    private final EventHubsProcessorFactory processorFactory;
    private final EventHubsContainerProperties containerProperties;
    private EventHubsErrorHandler errorHandler;
    private EventProcessorClient delegate;

    public EventHubsMessageListenerContainer(EventHubsProcessorFactory processorFactory, EventHubsContainerProperties containerProperties) {
        this.processorFactory = processorFactory;
        this.containerProperties = containerProperties == null ? new EventHubsContainerProperties() : containerProperties;
    }

    protected void doStart() {
        String eventHubName = this.containerProperties.getEventHubName();
        String consumerGroup = this.containerProperties.getConsumerGroup();
        if (this.errorHandler != null) {
            this.containerProperties.setErrorHandler(this.errorHandler);
        }
        this.delegate = this.processorFactory.createProcessor(eventHubName, consumerGroup, this.containerProperties);
        this.delegate.start();
    }

    protected void doStop() {
        if (this.delegate != null) {
            this.delegate.stop();
        }
    }

    public void setupMessageListener(MessageListener<?> messageListener) {
        this.containerProperties.setMessageListener(messageListener);
    }

    public EventHubsContainerProperties getContainerProperties() {
        return this.containerProperties;
    }

    public void setErrorHandler(EventHubsErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }
}

