/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.integration.storage.queue.inbound;

import com.azure.spring.messaging.storage.queue.core.StorageQueueTemplate;
import java.time.Duration;
import org.springframework.integration.endpoint.AbstractMessageSource;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class StorageQueueMessageSource
extends AbstractMessageSource<Message<?>> {
    private final StorageQueueTemplate storageQueueTemplate;
    private final String destination;
    private final Duration visibilityTimeout;

    public StorageQueueMessageSource(String destination, StorageQueueTemplate storageQueueTemplate) {
        this(destination, storageQueueTemplate, null);
    }

    public StorageQueueMessageSource(String destination, StorageQueueTemplate storageQueueTemplate, Duration visibilityTimeout) {
        Assert.hasText((String)destination, (String)"destination can't be null or empty");
        this.storageQueueTemplate = storageQueueTemplate;
        this.destination = destination;
        this.visibilityTimeout = visibilityTimeout;
    }

    public Object doReceive() {
        return this.storageQueueTemplate.receiveAsync(this.destination, this.visibilityTimeout).block();
    }

    public String getComponentType() {
        return "storage-queue:message-source";
    }
}

