/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.integration.servicebus.inbound;

import com.azure.messaging.servicebus.ServiceBusErrorContext;
import com.azure.messaging.servicebus.ServiceBusMessage;
import com.azure.messaging.servicebus.ServiceBusReceivedMessage;
import com.azure.messaging.servicebus.ServiceBusReceivedMessageContext;
import com.azure.spring.cloud.service.listener.MessageListener;
import com.azure.spring.cloud.service.servicebus.consumer.ServiceBusErrorHandler;
import com.azure.spring.integration.core.instrumentation.Instrumentation;
import com.azure.spring.integration.core.instrumentation.InstrumentationManager;
import com.azure.spring.integration.servicebus.implementation.health.ServiceBusProcessorInstrumentation;
import com.azure.spring.messaging.ListenerMode;
import com.azure.spring.messaging.converter.AzureMessageConverter;
import com.azure.spring.messaging.implementation.checkpoint.AzureCheckpointer;
import com.azure.spring.messaging.servicebus.core.listener.ServiceBusMessageListenerContainer;
import com.azure.spring.messaging.servicebus.implementation.core.listener.adapter.RecordMessagingMessageListenerAdapter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class ServiceBusInboundChannelAdapter
extends MessageProducerSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceBusInboundChannelAdapter.class);
    private final IntegrationRecordMessageListener recordListener = new IntegrationRecordMessageListener();
    private final ServiceBusMessageListenerContainer listenerContainer;
    private final ListenerMode listenerMode;
    private InstrumentationManager instrumentationManager;
    private String instrumentationId;
    private final boolean isAutoComplete;
    private static final String MSG_FAIL_CHECKPOINT = "Failed to checkpoint %s";

    public ServiceBusInboundChannelAdapter(ServiceBusMessageListenerContainer listenerContainer) {
        this(listenerContainer, ListenerMode.RECORD);
    }

    public ServiceBusInboundChannelAdapter(ServiceBusMessageListenerContainer listenerContainer, ListenerMode listenerMode) {
        this.listenerContainer = listenerContainer;
        this.listenerMode = listenerMode;
        this.isAutoComplete = !Boolean.FALSE.equals(listenerContainer.getContainerProperties().getAutoComplete());
    }

    protected void onInit() {
        Assert.state((ListenerMode.RECORD == this.listenerMode ? 1 : 0) != 0, (String)"Only record mode is supported!");
        this.listenerContainer.setupMessageListener((MessageListener)this.recordListener);
        this.listenerContainer.getContainerProperties().setErrorHandler((ServiceBusErrorHandler)new IntegrationErrorHandler());
    }

    public void doStart() {
        this.listenerContainer.start();
    }

    public void setMessageConverter(AzureMessageConverter<ServiceBusReceivedMessage, ServiceBusMessage> messageConverter) {
        this.recordListener.setMessageConverter(messageConverter);
    }

    public void setPayloadType(Class<?> payloadType) {
        this.recordListener.setPayloadType(payloadType);
    }

    public void setInstrumentationManager(InstrumentationManager instrumentationManager) {
        this.instrumentationManager = instrumentationManager;
    }

    public void setInstrumentationId(String instrumentationId) {
        this.instrumentationId = instrumentationId;
    }

    private class IntegrationRecordMessageListener
    extends RecordMessagingMessageListenerAdapter {
        private IntegrationRecordMessageListener() {
        }

        public void onMessage(ServiceBusReceivedMessageContext messageContext) {
            HashMap<String, Object> headers = new HashMap<String, Object>();
            headers.put("azure_service_bus_received_message_context", messageContext);
            if (!ServiceBusInboundChannelAdapter.this.isAutoComplete) {
                AzureCheckpointer checkpointer = new AzureCheckpointer(() -> Mono.fromRunnable(() -> ((ServiceBusReceivedMessageContext)messageContext).complete()), () -> Mono.fromRunnable(() -> ((ServiceBusReceivedMessageContext)messageContext).abandon()));
                headers.put("azure_checkpointer", checkpointer);
            }
            Message message = this.getMessageConverter().toMessage((Object)messageContext.getMessage(), (Map)new MessageHeaders(headers), this.payloadType);
            ServiceBusInboundChannelAdapter.this.sendMessage(message);
        }
    }

    private class IntegrationErrorHandler
    implements ServiceBusErrorHandler {
        private IntegrationErrorHandler() {
        }

        public void accept(ServiceBusErrorContext errorContext) {
            LOGGER.error("Error in the operation {} occurred on entity {}. Error: {}", new Object[]{errorContext.getErrorSource(), errorContext.getEntityPath(), errorContext.getException()});
            this.updateInstrumentation(errorContext);
        }

        private void updateInstrumentation(ServiceBusErrorContext errorContext) {
            if (ServiceBusInboundChannelAdapter.this.instrumentationManager == null || ServiceBusInboundChannelAdapter.this.instrumentationId == null) {
                LOGGER.debug("InstrumentationManager or instrumentationId is null, skip updateInstrumentation.");
                return;
            }
            Instrumentation instrumentation = ServiceBusInboundChannelAdapter.this.instrumentationManager.getHealthInstrumentation(ServiceBusInboundChannelAdapter.this.instrumentationId);
            if (instrumentation != null) {
                if (instrumentation instanceof ServiceBusProcessorInstrumentation) {
                    ((ServiceBusProcessorInstrumentation)instrumentation).markError(errorContext);
                } else {
                    instrumentation.setStatus(Instrumentation.Status.DOWN, errorContext.getException());
                }
            }
        }
    }
}

