/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.stream.binder.servicebus.provisioning;

import com.azure.spring.cloud.resourcemanager.provisioning.ServiceBusProvisioner;
import com.azure.spring.cloud.resourcemanager.provisioning.properties.ServiceBusEntityProperties;
import com.azure.spring.cloud.resourcemanager.provisioning.properties.ServiceBusQueueProperties;
import com.azure.spring.cloud.resourcemanager.provisioning.properties.ServiceBusTopicProperties;
import com.azure.spring.cloud.service.servicebus.properties.ServiceBusEntityType;
import com.azure.spring.cloud.stream.binder.servicebus.core.properties.ServiceBusConsumerProperties;
import com.azure.spring.cloud.stream.binder.servicebus.core.properties.ServiceBusEntityOptionsProvider;
import com.azure.spring.cloud.stream.binder.servicebus.core.properties.ServiceBusProducerProperties;
import com.azure.spring.cloud.stream.binder.servicebus.core.provisioning.ServiceBusChannelProvisioner;
import com.azure.spring.cloud.stream.binder.servicebus.core.provisioning.ServiceBusConsumerDestination;
import com.azure.spring.cloud.stream.binder.servicebus.core.provisioning.ServiceBusProducerDestination;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningException;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class ServiceBusChannelResourceManagerProvisioner
extends ServiceBusChannelProvisioner {
    private final String namespace;
    private final ServiceBusProvisioner serviceBusProvisioner;

    public ServiceBusChannelResourceManagerProvisioner(@NonNull String namespace, @NonNull ServiceBusProvisioner serviceBusProvisioner) {
        Assert.hasText((String)namespace, (String)"The namespace can't be null or empty");
        this.namespace = namespace;
        this.serviceBusProvisioner = serviceBusProvisioner;
    }

    public ProducerDestination provisionProducerDestination(String name, ExtendedProducerProperties<ServiceBusProducerProperties> extendedProducerProperties) throws ProvisioningException {
        ServiceBusProducerProperties producerProperties = (ServiceBusProducerProperties)extendedProducerProperties.getExtension();
        Assert.notNull((Object)producerProperties.getEntityType(), (String)"The EntityType of the producer can't be null.");
        if (ServiceBusEntityType.QUEUE == producerProperties.getEntityType()) {
            this.serviceBusProvisioner.provisionQueue(this.namespace, name, this.buildEntityProperties((ServiceBusEntityOptionsProvider)producerProperties, ServiceBusQueueProperties.class));
        } else {
            this.serviceBusProvisioner.provisionTopic(this.namespace, name, this.buildEntityProperties((ServiceBusEntityOptionsProvider)producerProperties, ServiceBusTopicProperties.class));
        }
        return new ServiceBusProducerDestination(name);
    }

    public ConsumerDestination provisionConsumerDestination(String name, String group, ExtendedConsumerProperties<ServiceBusConsumerProperties> extendedConsumerProperties) throws ProvisioningException {
        ServiceBusConsumerProperties consumerProperties = (ServiceBusConsumerProperties)extendedConsumerProperties.getExtension();
        Assert.notNull((Object)consumerProperties.getEntityType(), (String)"The EntityType of the consumer can't be null.");
        if (ServiceBusEntityType.QUEUE == consumerProperties.getEntityType()) {
            this.serviceBusProvisioner.provisionQueue(this.namespace, name, this.buildEntityProperties((ServiceBusEntityOptionsProvider)consumerProperties, ServiceBusQueueProperties.class));
        } else {
            this.serviceBusProvisioner.provisionSubscription(this.namespace, name, group, this.buildEntityProperties((ServiceBusEntityOptionsProvider)consumerProperties, ServiceBusTopicProperties.class));
        }
        return new ServiceBusConsumerDestination(name);
    }

    private <T extends ServiceBusEntityProperties> T buildEntityProperties(ServiceBusEntityOptionsProvider entityOptionsProvider, Class<T> clazz) {
        ServiceBusEntityProperties entityProperties = null;
        try {
            entityProperties = (ServiceBusEntityProperties)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        entityProperties.setDefaultMessageTimeToLive(entityOptionsProvider.getDefaultMessageTimeToLive());
        entityProperties.setMaxSizeInMegabytes(entityOptionsProvider.getMaxSizeInMegabytes());
        return (T)entityProperties;
    }
}

