/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.storage.fileshare;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.spring.cloud.core.implementation.credential.descriptor.AuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.SasAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.implementation.storage.common.AbstractAzureStorageClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.storage.common.credential.StorageSharedKeyAuthenticationDescriptor;
import com.azure.spring.cloud.service.implementation.storage.fileshare.ShareServiceClientProperties;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.file.share.ShareServiceClientBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShareServiceClientBuilderFactory
extends AbstractAzureStorageClientBuilderFactory<ShareServiceClientBuilder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShareServiceClientBuilderFactory.class);
    private final ShareServiceClientProperties shareServiceClientProperties;

    public ShareServiceClientBuilderFactory(ShareServiceClientProperties shareServiceClientProperties) {
        this.shareServiceClientProperties = shareServiceClientProperties;
    }

    protected BiConsumer<ShareServiceClientBuilder, ClientOptions> consumeClientOptions() {
        return ShareServiceClientBuilder::clientOptions;
    }

    protected BiConsumer<ShareServiceClientBuilder, HttpClient> consumeHttpClient() {
        return ShareServiceClientBuilder::httpClient;
    }

    protected BiConsumer<ShareServiceClientBuilder, HttpPipelinePolicy> consumeHttpPipelinePolicy() {
        return ShareServiceClientBuilder::addPolicy;
    }

    protected BiConsumer<ShareServiceClientBuilder, HttpPipeline> consumeHttpPipeline() {
        return ShareServiceClientBuilder::pipeline;
    }

    protected BiConsumer<ShareServiceClientBuilder, HttpLogOptions> consumeHttpLogOptions() {
        return ShareServiceClientBuilder::httpLogOptions;
    }

    protected ShareServiceClientBuilder createBuilderInstance() {
        return new ShareServiceClientBuilder();
    }

    protected AzureProperties getAzureProperties() {
        return this.shareServiceClientProperties;
    }

    protected List<AuthenticationDescriptor<?>> getAuthenticationDescriptors(ShareServiceClientBuilder builder) {
        AuthenticationDescriptor[] authenticationDescriptorArray = new AuthenticationDescriptor[2];
        authenticationDescriptorArray[0] = new StorageSharedKeyAuthenticationDescriptor(arg_0 -> ((ShareServiceClientBuilder)builder).credential(arg_0));
        authenticationDescriptorArray[1] = new SasAuthenticationDescriptor(arg_0 -> ((ShareServiceClientBuilder)builder).credential(arg_0));
        return Arrays.asList(authenticationDescriptorArray);
    }

    protected void configureService(ShareServiceClientBuilder builder) {
        PropertyMapper map = new PropertyMapper();
        map.from((Object)this.shareServiceClientProperties.getEndpoint()).to(arg_0 -> ((ShareServiceClientBuilder)builder).endpoint(arg_0));
        map.from((Object)this.shareServiceClientProperties.getServiceVersion()).to(arg_0 -> ((ShareServiceClientBuilder)builder).serviceVersion(arg_0));
    }

    protected BiConsumer<ShareServiceClientBuilder, Configuration> consumeConfiguration() {
        return ShareServiceClientBuilder::configuration;
    }

    protected BiConsumer<ShareServiceClientBuilder, TokenCredential> consumeDefaultTokenCredential() {
        LOGGER.warn("TokenCredential is not supported to configure in ShareServiceClientBuilder.");
        return (a, b) -> {};
    }

    protected BiConsumer<ShareServiceClientBuilder, String> consumeConnectionString() {
        return ShareServiceClientBuilder::connectionString;
    }

    @Override
    protected BiConsumer<ShareServiceClientBuilder, RequestRetryOptions> consumeRequestRetryOptions() {
        return ShareServiceClientBuilder::retryOptions;
    }
}

