/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.eventgrid.factory;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.messaging.eventgrid.EventGridPublisherClientBuilder;
import com.azure.spring.cloud.core.implementation.credential.descriptor.AuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.KeyAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.SasAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.TokenAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.factory.AbstractAzureHttpClientBuilderFactory;
import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.implementation.eventgrid.properties.EventGridPublisherClientProperties;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventGridPublisherClientBuilderFactory
extends AbstractAzureHttpClientBuilderFactory<EventGridPublisherClientBuilder> {
    public static final Logger LOGGER = LoggerFactory.getLogger(EventGridPublisherClientBuilderFactory.class);
    private final EventGridPublisherClientProperties eventGridPublisherClientProperties;

    public EventGridPublisherClientBuilderFactory(EventGridPublisherClientProperties properties) {
        this.eventGridPublisherClientProperties = properties;
    }

    protected BiConsumer<EventGridPublisherClientBuilder, ClientOptions> consumeClientOptions() {
        return EventGridPublisherClientBuilder::clientOptions;
    }

    protected BiConsumer<EventGridPublisherClientBuilder, HttpClient> consumeHttpClient() {
        return EventGridPublisherClientBuilder::httpClient;
    }

    protected BiConsumer<EventGridPublisherClientBuilder, HttpPipelinePolicy> consumeHttpPipelinePolicy() {
        return EventGridPublisherClientBuilder::addPolicy;
    }

    protected BiConsumer<EventGridPublisherClientBuilder, HttpPipeline> consumeHttpPipeline() {
        return EventGridPublisherClientBuilder::pipeline;
    }

    protected BiConsumer<EventGridPublisherClientBuilder, HttpLogOptions> consumeHttpLogOptions() {
        return EventGridPublisherClientBuilder::httpLogOptions;
    }

    protected BiConsumer<EventGridPublisherClientBuilder, RetryPolicy> consumeRetryPolicy() {
        return EventGridPublisherClientBuilder::retryPolicy;
    }

    protected EventGridPublisherClientBuilder createBuilderInstance() {
        return new EventGridPublisherClientBuilder();
    }

    protected AzureProperties getAzureProperties() {
        return this.eventGridPublisherClientProperties;
    }

    protected List<AuthenticationDescriptor<?>> getAuthenticationDescriptors(EventGridPublisherClientBuilder builder) {
        AuthenticationDescriptor[] authenticationDescriptorArray = new AuthenticationDescriptor[3];
        authenticationDescriptorArray[0] = new KeyAuthenticationDescriptor(arg_0 -> ((EventGridPublisherClientBuilder)builder).credential(arg_0));
        authenticationDescriptorArray[1] = new SasAuthenticationDescriptor(arg_0 -> ((EventGridPublisherClientBuilder)builder).credential(arg_0));
        authenticationDescriptorArray[2] = new TokenAuthenticationDescriptor(this.tokenCredentialResolver, arg_0 -> ((EventGridPublisherClientBuilder)builder).credential(arg_0));
        return Arrays.asList(authenticationDescriptorArray);
    }

    protected void configureService(EventGridPublisherClientBuilder builder) {
        PropertyMapper map = new PropertyMapper();
        map.from((Object)this.eventGridPublisherClientProperties.getEndpoint()).to(arg_0 -> ((EventGridPublisherClientBuilder)builder).endpoint(arg_0));
        map.from((Object)this.eventGridPublisherClientProperties.getServiceVersion()).to(arg_0 -> ((EventGridPublisherClientBuilder)builder).serviceVersion(arg_0));
    }

    protected BiConsumer<EventGridPublisherClientBuilder, Configuration> consumeConfiguration() {
        return EventGridPublisherClientBuilder::configuration;
    }

    protected BiConsumer<EventGridPublisherClientBuilder, TokenCredential> consumeDefaultTokenCredential() {
        return EventGridPublisherClientBuilder::credential;
    }

    protected BiConsumer<EventGridPublisherClientBuilder, String> consumeConnectionString() {
        LOGGER.debug("Connection string is not supported to configure in EventGridPublisherClientBuilder");
        return (a, b) -> {};
    }
}

