/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.redis;

import java.util.Objects;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import redis.clients.jedis.HostAndPortMapper;
import redis.clients.jedis.JedisClientConfig;

public final class AzureJedisClientConfig
implements JedisClientConfig {
    private final int connectionTimeoutMillis;
    private final int socketTimeoutMillis;
    private final int blockingSocketTimeoutMillis;
    private final String user;
    private volatile String password;
    private final int database;
    private final String clientName;
    private final boolean ssl;
    private final SSLSocketFactory sslSocketFactory;
    private final SSLParameters sslParameters;
    private final HostnameVerifier hostnameVerifier;
    private final HostAndPortMapper hostAndPortMapper;
    private Supplier<String> credentialSupplier;

    private AzureJedisClientConfig(int connectionTimeoutMillis, int soTimeoutMillis, int blockingSocketTimeoutMillis, String user, String password, int database, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, HostAndPortMapper hostAndPortMapper, Supplier<String> credentialSupplier) {
        this.connectionTimeoutMillis = connectionTimeoutMillis;
        this.socketTimeoutMillis = soTimeoutMillis;
        this.blockingSocketTimeoutMillis = blockingSocketTimeoutMillis;
        this.user = user;
        this.password = password;
        this.database = database;
        this.clientName = clientName;
        this.ssl = ssl;
        this.sslSocketFactory = sslSocketFactory;
        this.sslParameters = sslParameters;
        this.hostnameVerifier = hostnameVerifier;
        this.hostAndPortMapper = hostAndPortMapper;
        this.credentialSupplier = credentialSupplier;
    }

    public int getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    public int getSocketTimeoutMillis() {
        return this.socketTimeoutMillis;
    }

    public int getBlockingSocketTimeoutMillis() {
        return this.blockingSocketTimeoutMillis;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        if (this.password != null) {
            return this.password;
        }
        if (this.credentialSupplier != null) {
            return this.credentialSupplier.get();
        }
        return this.password;
    }

    public synchronized void updatePassword(String password) {
        if (!Objects.equals(this.password, password)) {
            this.password = password;
        }
    }

    public int getDatabase() {
        return this.database;
    }

    public String getClientName() {
        return this.clientName;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public SSLParameters getSslParameters() {
        return this.sslParameters;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public HostAndPortMapper getHostAndPortMapper() {
        return this.hostAndPortMapper;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private int connectionTimeoutMillis = 2000;
        private int socketTimeoutMillis = 2000;
        private int blockingSocketTimeoutMillis = 0;
        private String user = null;
        private String password = null;
        private Supplier<String> credentialSupplier = null;
        private int database = 0;
        private String clientName = null;
        private boolean ssl = false;
        private SSLSocketFactory sslSocketFactory = null;
        private SSLParameters sslParameters = null;
        private HostnameVerifier hostnameVerifier = null;
        private HostAndPortMapper hostAndPortMapper = null;

        private Builder() {
        }

        public AzureJedisClientConfig build() {
            return new AzureJedisClientConfig(this.connectionTimeoutMillis, this.socketTimeoutMillis, this.blockingSocketTimeoutMillis, this.user, this.password, this.database, this.clientName, this.ssl, this.sslSocketFactory, this.sslParameters, this.hostnameVerifier, this.hostAndPortMapper, this.credentialSupplier);
        }

        public Builder connectionTimeoutMillis(int connectionTimeoutMillis) {
            this.connectionTimeoutMillis = connectionTimeoutMillis;
            return this;
        }

        public Builder socketTimeoutMillis(int socketTimeoutMillis) {
            this.socketTimeoutMillis = socketTimeoutMillis;
            return this;
        }

        public Builder blockingSocketTimeoutMillis(int blockingSocketTimeoutMillis) {
            this.blockingSocketTimeoutMillis = blockingSocketTimeoutMillis;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder credentialSupplier(Supplier<String> credentialSupplier) {
            this.credentialSupplier = credentialSupplier;
            return this;
        }

        public Builder database(int database) {
            this.database = database;
            return this;
        }

        public Builder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public Builder ssl(boolean ssl) {
            this.ssl = ssl;
            return this;
        }

        public Builder sslSocketFactory(SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
            return this;
        }

        public Builder sslParameters(SSLParameters sslParameters) {
            this.sslParameters = sslParameters;
            return this;
        }

        public Builder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder hostAndPortMapper(HostAndPortMapper hostAndPortMapper) {
            this.hostAndPortMapper = hostAndPortMapper;
            return this;
        }
    }
}

