/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.eventhubs.factory;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.credential.TokenCredential;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.messaging.eventhubs.CheckpointStore;
import com.azure.messaging.eventhubs.EventProcessorClientBuilder;
import com.azure.messaging.eventhubs.models.CloseContext;
import com.azure.messaging.eventhubs.models.EventPosition;
import com.azure.messaging.eventhubs.models.InitializationContext;
import com.azure.spring.cloud.core.implementation.credential.descriptor.AuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.NamedKeyAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.SasAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.TokenAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.factory.AbstractAzureAmqpClientBuilderFactory;
import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.eventhubs.consumer.EventHubsBatchMessageListener;
import com.azure.spring.cloud.service.eventhubs.consumer.EventHubsErrorHandler;
import com.azure.spring.cloud.service.eventhubs.consumer.EventHubsRecordMessageListener;
import com.azure.spring.cloud.service.implementation.converter.EventPositionConverter;
import com.azure.spring.cloud.service.implementation.eventhubs.properties.EventProcessorClientProperties;
import com.azure.spring.cloud.service.listener.MessageListener;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class EventProcessorClientBuilderFactory
extends AbstractAzureAmqpClientBuilderFactory<EventProcessorClientBuilder> {
    private final EventProcessorClientProperties eventProcessorClientProperties;
    private final CheckpointStore checkpointStore;
    private final MessageListener<?> messageListener;
    private final EventHubsErrorHandler errorHandler;
    private Consumer<CloseContext> closeContextConsumer;
    private Consumer<InitializationContext> initializationContextConsumer;

    public EventProcessorClientBuilderFactory(EventProcessorClientProperties eventProcessorClientProperties, CheckpointStore checkpointStore, MessageListener<?> listener, EventHubsErrorHandler errorHandler) {
        this.eventProcessorClientProperties = eventProcessorClientProperties;
        this.checkpointStore = checkpointStore;
        this.messageListener = listener;
        this.errorHandler = errorHandler;
    }

    protected BiConsumer<EventProcessorClientBuilder, ProxyOptions> consumeProxyOptions() {
        return EventProcessorClientBuilder::proxyOptions;
    }

    protected BiConsumer<EventProcessorClientBuilder, AmqpTransportType> consumeAmqpTransportType() {
        return EventProcessorClientBuilder::transportType;
    }

    protected BiConsumer<EventProcessorClientBuilder, AmqpRetryOptions> consumeAmqpRetryOptions() {
        return EventProcessorClientBuilder::retry;
    }

    protected BiConsumer<EventProcessorClientBuilder, ClientOptions> consumeClientOptions() {
        return EventProcessorClientBuilder::clientOptions;
    }

    protected EventProcessorClientBuilder createBuilderInstance() {
        return new EventProcessorClientBuilder();
    }

    protected AzureProperties getAzureProperties() {
        return this.eventProcessorClientProperties;
    }

    protected void configureService(EventProcessorClientBuilder builder) {
        PropertyMapper map = new PropertyMapper();
        map.from((Object)this.eventProcessorClientProperties.getFullyQualifiedNamespace()).to(arg_0 -> ((EventProcessorClientBuilder)builder).fullyQualifiedNamespace(arg_0));
        map.from((Object)this.eventProcessorClientProperties.getEventHubName()).to(arg_0 -> ((EventProcessorClientBuilder)builder).eventHubName(arg_0));
        map.from((Object)this.eventProcessorClientProperties.getConsumerGroup()).to(arg_0 -> ((EventProcessorClientBuilder)builder).consumerGroup(arg_0));
        map.from((Object)this.eventProcessorClientProperties.getPrefetchCount()).to(arg_0 -> ((EventProcessorClientBuilder)builder).prefetchCount(arg_0));
        map.from((Object)this.eventProcessorClientProperties.getCustomEndpointAddress()).to(arg_0 -> ((EventProcessorClientBuilder)builder).customEndpointAddress(arg_0));
        map.from((Object)this.eventProcessorClientProperties.getTrackLastEnqueuedEventProperties()).to(arg_0 -> ((EventProcessorClientBuilder)builder).trackLastEnqueuedEventProperties(arg_0));
        map.from((Object)this.eventProcessorClientProperties.getLoadBalancing().getPartitionOwnershipExpirationInterval()).to(arg_0 -> ((EventProcessorClientBuilder)builder).partitionOwnershipExpirationInterval(arg_0));
        map.from((Object)this.eventProcessorClientProperties.getLoadBalancing().getStrategy()).to(arg_0 -> ((EventProcessorClientBuilder)builder).loadBalancingStrategy(arg_0));
        map.from((Object)this.eventProcessorClientProperties.getLoadBalancing().getUpdateInterval()).to(arg_0 -> ((EventProcessorClientBuilder)builder).loadBalancingUpdateInterval(arg_0));
        map.from(this.eventProcessorClientProperties.getInitialPartitionEventPosition()).when(c -> !CollectionUtils.isEmpty((Map)c)).to(m -> {
            Map<String, EventPosition> eventPositionMap = m.entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, entry -> EventPositionConverter.EVENT_POSITION_CONVERTER.convert((EventProcessorClientProperties.StartPosition)entry.getValue())));
            builder.initialPartitionEventPosition(eventPositionMap);
        });
        map.from((Object)this.errorHandler).to(arg_0 -> ((EventProcessorClientBuilder)builder).processError(arg_0));
        map.from(this.initializationContextConsumer).to(arg_0 -> ((EventProcessorClientBuilder)builder).processPartitionInitialization(arg_0));
        map.from(this.closeContextConsumer).to(arg_0 -> ((EventProcessorClientBuilder)builder).processPartitionClose(arg_0));
        this.configureCheckpointStore(builder);
        this.configureMessageListener(builder);
    }

    protected List<AuthenticationDescriptor<?>> getAuthenticationDescriptors(EventProcessorClientBuilder builder) {
        AuthenticationDescriptor[] authenticationDescriptorArray = new AuthenticationDescriptor[3];
        authenticationDescriptorArray[0] = new NamedKeyAuthenticationDescriptor(arg_0 -> ((EventProcessorClientBuilder)builder).credential(arg_0));
        authenticationDescriptorArray[1] = new SasAuthenticationDescriptor(arg_0 -> ((EventProcessorClientBuilder)builder).credential(arg_0));
        authenticationDescriptorArray[2] = new TokenAuthenticationDescriptor(this.tokenCredentialResolver, c -> builder.credential(c));
        return Arrays.asList(authenticationDescriptorArray);
    }

    protected BiConsumer<EventProcessorClientBuilder, Configuration> consumeConfiguration() {
        return EventProcessorClientBuilder::configuration;
    }

    protected BiConsumer<EventProcessorClientBuilder, TokenCredential> consumeDefaultTokenCredential() {
        return (builder, tokenCredential) -> builder.credential(tokenCredential);
    }

    protected BiConsumer<EventProcessorClientBuilder, String> consumeConnectionString() {
        return (builder, s) -> builder.connectionString(s, this.eventProcessorClientProperties.getEventHubName());
    }

    private void configureCheckpointStore(EventProcessorClientBuilder builder) {
        builder.checkpointStore(this.checkpointStore);
    }

    private void configureMessageListener(EventProcessorClientBuilder builder) {
        EventProcessorClientProperties.EventBatch batch = this.eventProcessorClientProperties.getBatch();
        if (this.messageListener instanceof EventHubsBatchMessageListener) {
            Assert.notNull((Object)batch.getMaxSize(), (String)"Batch max size must be provided");
            builder.processEventBatch(((EventHubsBatchMessageListener)this.messageListener)::onMessage, batch.getMaxSize().intValue(), batch.getMaxWaitTime());
        } else if (this.messageListener instanceof EventHubsRecordMessageListener) {
            builder.processEvent(((EventHubsRecordMessageListener)this.messageListener)::onMessage);
        } else {
            throw new IllegalArgumentException("Listener must be of one 'EventHubsBatchMessageListener' or 'EventHubsRecordMessageListener', not " + this.messageListener.getClass().getName());
        }
    }

    public void setCloseContextConsumer(Consumer<CloseContext> closeContextConsumer) {
        this.closeContextConsumer = closeContextConsumer;
    }

    public void setInitializationContextConsumer(Consumer<InitializationContext> initializationContextConsumer) {
        this.initializationContextConsumer = initializationContextConsumer;
    }
}

