/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.eventhubs.factory;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.amqp.implementation.ConnectionStringProperties;
import com.azure.core.credential.TokenCredential;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.messaging.eventhubs.EventHubClientBuilder;
import com.azure.messaging.eventhubs.implementation.ClientConstants;
import com.azure.messaging.eventhubs.implementation.EventHubSharedKeyCredential;
import com.azure.spring.cloud.core.implementation.credential.descriptor.AuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.NamedKeyAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.SasAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.TokenAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.factory.AbstractAzureAmqpClientBuilderFactory;
import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.implementation.eventhubs.properties.EventHubClientCommonProperties;
import com.azure.spring.cloud.service.implementation.eventhubs.properties.EventHubConsumerProperties;
import com.azure.spring.cloud.service.implementation.eventhubs.properties.EventHubsNamespaceProperties;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class EventHubClientBuilderFactory
extends AbstractAzureAmqpClientBuilderFactory<EventHubClientBuilder> {
    public static final Logger LOGGER = LoggerFactory.getLogger(EventHubClientBuilderFactory.class);
    private final EventHubClientCommonProperties eventHubsProperties;

    public EventHubClientBuilderFactory(EventHubClientCommonProperties eventHubsProperties) {
        this.eventHubsProperties = eventHubsProperties;
    }

    protected BiConsumer<EventHubClientBuilder, ProxyOptions> consumeProxyOptions() {
        return EventHubClientBuilder::proxyOptions;
    }

    protected BiConsumer<EventHubClientBuilder, AmqpTransportType> consumeAmqpTransportType() {
        return EventHubClientBuilder::transportType;
    }

    protected BiConsumer<EventHubClientBuilder, AmqpRetryOptions> consumeAmqpRetryOptions() {
        return EventHubClientBuilder::retryOptions;
    }

    protected BiConsumer<EventHubClientBuilder, ClientOptions> consumeClientOptions() {
        return EventHubClientBuilder::clientOptions;
    }

    protected BiConsumer<EventHubClientBuilder, Configuration> consumeConfiguration() {
        return EventHubClientBuilder::configuration;
    }

    protected BiConsumer<EventHubClientBuilder, TokenCredential> consumeDefaultTokenCredential() {
        return (builder, tokenCredential) -> builder.credential(tokenCredential);
    }

    protected BiConsumer<EventHubClientBuilder, String> consumeConnectionString() {
        return (builder, connectionString) -> {
            if (StringUtils.hasText((String)this.eventHubsProperties.getEventHubName())) {
                builder.connectionString(connectionString, this.eventHubsProperties.getEventHubName());
            } else {
                LOGGER.info("The eventhub name is not configured, will call credential method instead of connectionString method.");
                ConnectionStringProperties properties = new ConnectionStringProperties(connectionString);
                TokenCredential tokenCredential = this.getTokenCredential(properties);
                builder.credential(tokenCredential);
            }
        };
    }

    protected EventHubClientBuilder createBuilderInstance() {
        return new EventHubClientBuilder();
    }

    protected AzureProperties getAzureProperties() {
        return this.eventHubsProperties;
    }

    protected void configureService(EventHubClientBuilder builder) {
        PropertyMapper mapper = new PropertyMapper();
        mapper.from((Object)this.eventHubsProperties.getCustomEndpointAddress()).to(arg_0 -> ((EventHubClientBuilder)builder).customEndpointAddress(arg_0));
        mapper.from((Object)this.eventHubsProperties.getFullyQualifiedNamespace()).to(arg_0 -> ((EventHubClientBuilder)builder).fullyQualifiedNamespace(arg_0));
        mapper.from((Object)this.eventHubsProperties.getEventHubName()).to(arg_0 -> ((EventHubClientBuilder)builder).eventHubName(arg_0));
        if (this.eventHubsProperties instanceof EventHubsNamespaceProperties) {
            mapper.from((Object)((EventHubsNamespaceProperties)this.eventHubsProperties).getSharedConnection()).whenTrue().to(t -> builder.shareConnection());
        }
        if (this.eventHubsProperties instanceof EventHubConsumerProperties) {
            EventHubConsumerProperties consumerProperties = (EventHubConsumerProperties)this.eventHubsProperties;
            mapper.from((Object)consumerProperties.getConsumerGroup()).to(arg_0 -> ((EventHubClientBuilder)builder).consumerGroup(arg_0));
            mapper.from((Object)consumerProperties.getPrefetchCount()).to(arg_0 -> ((EventHubClientBuilder)builder).prefetchCount(arg_0));
        }
    }

    protected List<AuthenticationDescriptor<?>> getAuthenticationDescriptors(EventHubClientBuilder builder) {
        AuthenticationDescriptor[] authenticationDescriptorArray = new AuthenticationDescriptor[3];
        authenticationDescriptorArray[0] = new NamedKeyAuthenticationDescriptor(arg_0 -> ((EventHubClientBuilder)builder).credential(arg_0));
        authenticationDescriptorArray[1] = new SasAuthenticationDescriptor(arg_0 -> ((EventHubClientBuilder)builder).credential(arg_0));
        authenticationDescriptorArray[2] = new TokenAuthenticationDescriptor(this.tokenCredentialResolver, c -> builder.credential(c));
        return Arrays.asList(authenticationDescriptorArray);
    }

    private TokenCredential getTokenCredential(ConnectionStringProperties properties) {
        EventHubSharedKeyCredential tokenCredential = properties.getSharedAccessSignature() == null ? new EventHubSharedKeyCredential(properties.getSharedAccessKeyName(), properties.getSharedAccessKey(), ClientConstants.TOKEN_VALIDITY) : new EventHubSharedKeyCredential(properties.getSharedAccessSignature());
        return tokenCredential;
    }
}

