/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.servicebus.factory;

import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.service.implementation.servicebus.factory.AbstractServiceBusSubClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.servicebus.properties.ServiceBusSenderClientProperties;
import com.azure.spring.cloud.service.servicebus.properties.ServiceBusEntityType;
import org.springframework.util.Assert;

public class ServiceBusSenderClientBuilderFactory
extends AbstractServiceBusSubClientBuilderFactory<ServiceBusClientBuilder.ServiceBusSenderClientBuilder, ServiceBusSenderClientProperties> {
    private final ServiceBusSenderClientProperties senderClientProperties;

    public ServiceBusSenderClientBuilderFactory(ServiceBusSenderClientProperties senderClientProperties) {
        this((ServiceBusClientBuilder)null, senderClientProperties);
    }

    public ServiceBusSenderClientBuilderFactory(ServiceBusClientBuilder serviceBusClientBuilder, ServiceBusSenderClientProperties senderClientProperties) {
        super(serviceBusClientBuilder, senderClientProperties);
        this.senderClientProperties = senderClientProperties;
    }

    protected ServiceBusClientBuilder.ServiceBusSenderClientBuilder createBuilderInstance() {
        return this.getServiceBusClientBuilder().sender();
    }

    @Override
    protected void configureService(ServiceBusClientBuilder.ServiceBusSenderClientBuilder builder) {
        Assert.notNull((Object)((Object)this.senderClientProperties.getEntityType()), (String)"Entity type cannot be null.");
        Assert.notNull((Object)this.senderClientProperties.getEntityName(), (String)"Entity name cannot be null.");
        super.configureService(builder);
        PropertyMapper propertyMapper = new PropertyMapper();
        if (ServiceBusEntityType.QUEUE == this.senderClientProperties.getEntityType()) {
            propertyMapper.from((Object)this.senderClientProperties.getEntityName()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSenderClientBuilder)builder).queueName(arg_0));
        } else if (ServiceBusEntityType.TOPIC == this.senderClientProperties.getEntityType()) {
            propertyMapper.from((Object)this.senderClientProperties.getEntityName()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSenderClientBuilder)builder).topicName(arg_0));
        }
    }
}

