/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.resourcemanager.implementation.crud;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.eventhubs.models.EventHub;
import com.azure.resourcemanager.eventhubs.models.EventHubConsumerGroup;
import com.azure.spring.cloud.core.properties.resource.AzureResourceMetadata;
import com.azure.spring.cloud.resourcemanager.implementation.crud.AbstractResourceCrud;
import com.azure.spring.cloud.resourcemanager.implementation.crud.EventHubsCrud;
import reactor.util.function.Tuple3;
import reactor.util.function.Tuples;

public class EventHubsConsumerGroupCrud
extends AbstractResourceCrud<EventHubConsumerGroup, Tuple3<String, String, String>, Object> {
    public EventHubsConsumerGroupCrud(AzureResourceManager azureResourceManager, AzureResourceMetadata resourceMetadata) {
        super(azureResourceManager, resourceMetadata);
    }

    @Override
    String getResourceName(Tuple3<String, String, String> key) {
        return (String)key.getT3();
    }

    @Override
    String getResourceType() {
        return EventHubConsumerGroup.class.getSimpleName();
    }

    @Override
    public EventHubConsumerGroup internalGet(Tuple3<String, String, String> consumerGroupCoordinate) {
        try {
            return this.resourceManager.eventHubs().consumerGroups().getByName(this.resourceMetadata.getResourceGroup(), (String)consumerGroupCoordinate.getT1(), (String)consumerGroupCoordinate.getT2(), (String)consumerGroupCoordinate.getT3());
        }
        catch (ManagementException e) {
            if (e.getResponse().getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public EventHubConsumerGroup internalCreate(Tuple3<String, String, String> consumerGroupCoordinate) {
        return (EventHubConsumerGroup)((EventHubConsumerGroup.DefinitionStages.Blank)this.resourceManager.eventHubs().consumerGroups().define((String)consumerGroupCoordinate.getT3())).withExistingEventHub((EventHub)new EventHubsCrud(this.resourceManager, this.resourceMetadata).getOrCreate(Tuples.of((Object)((String)consumerGroupCoordinate.getT1()), (Object)((String)consumerGroupCoordinate.getT2())))).create();
    }
}

