/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.feature.management;

import com.azure.spring.cloud.feature.management.filters.ContextualFeatureFilter;
import com.azure.spring.cloud.feature.management.filters.ContextualFeatureFilterAsync;
import com.azure.spring.cloud.feature.management.filters.FeatureFilter;
import com.azure.spring.cloud.feature.management.filters.FeatureFilterAsync;
import com.azure.spring.cloud.feature.management.implementation.FeatureFilterUtils;
import com.azure.spring.cloud.feature.management.implementation.FeatureManagementConfigProperties;
import com.azure.spring.cloud.feature.management.implementation.FeatureManagementProperties;
import com.azure.spring.cloud.feature.management.models.Allocation;
import com.azure.spring.cloud.feature.management.models.Conditions;
import com.azure.spring.cloud.feature.management.models.EvaluationEvent;
import com.azure.spring.cloud.feature.management.models.FeatureDefinition;
import com.azure.spring.cloud.feature.management.models.FeatureFilterEvaluationContext;
import com.azure.spring.cloud.feature.management.models.FeatureManagementException;
import com.azure.spring.cloud.feature.management.models.FilterNotFoundException;
import com.azure.spring.cloud.feature.management.models.GroupAllocation;
import com.azure.spring.cloud.feature.management.models.PercentileAllocation;
import com.azure.spring.cloud.feature.management.models.UserAllocation;
import com.azure.spring.cloud.feature.management.models.Variant;
import com.azure.spring.cloud.feature.management.models.VariantAssignmentReason;
import com.azure.spring.cloud.feature.management.models.VariantReference;
import com.azure.spring.cloud.feature.management.targeting.TargetingContextAccessor;
import com.azure.spring.cloud.feature.management.targeting.TargetingEvaluationOptions;
import com.azure.spring.cloud.feature.management.targeting.TargetingFilterContext;
import com.azure.spring.cloud.feature.management.telemetry.TelemetryPublisher;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FeatureManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureManager.class);
    private static final double PERCENTILE_MAXIMUM = 100.0;
    private transient ApplicationContext context;
    private final FeatureManagementProperties featureManagementConfigurations;
    private transient FeatureManagementConfigProperties properties;
    private static final Duration DEFAULT_BLOCK_TIMEOUT = Duration.ofSeconds(100L);
    private final TargetingContextAccessor contextAccessor;
    private final TargetingEvaluationOptions evaluationOptions;
    private final TelemetryPublisher telemetryPublisher;

    FeatureManager(ApplicationContext context, FeatureManagementProperties featureManagementConfigurations, FeatureManagementConfigProperties properties, TargetingContextAccessor contextAccessor, TargetingEvaluationOptions evaluationOptions, TelemetryPublisher telemetryPublisher) {
        this.context = context;
        this.featureManagementConfigurations = featureManagementConfigurations;
        this.properties = properties;
        this.contextAccessor = contextAccessor;
        this.evaluationOptions = evaluationOptions;
        this.telemetryPublisher = telemetryPublisher;
    }

    public Mono<Boolean> isEnabledAsync(String feature) {
        return this.checkFeature(feature, null).map(event -> event.isEnabled());
    }

    public Boolean isEnabled(String feature) throws FilterNotFoundException {
        return (Boolean)this.checkFeature(feature, null).map(event -> event.isEnabled()).block(DEFAULT_BLOCK_TIMEOUT);
    }

    public Mono<Boolean> isEnabledAsync(String feature, Object featureContext) {
        return this.checkFeature(feature, featureContext).map(event -> event.isEnabled());
    }

    public Boolean isEnabled(String feature, Object featureContext) throws FilterNotFoundException {
        return (Boolean)this.checkFeature(feature, featureContext).map(event -> event.isEnabled()).block(DEFAULT_BLOCK_TIMEOUT);
    }

    public Variant getVariant(String feature) {
        return ((EvaluationEvent)this.checkFeature(feature, null).block()).getVariant();
    }

    public Variant getVariant(String feature, Object featureContext) {
        return ((EvaluationEvent)this.checkFeature(feature, featureContext).block()).getVariant();
    }

    public Mono<Variant> getVariantAsync(String feature) {
        return this.checkFeature(feature, null).map(event -> event.getVariant());
    }

    public Mono<Variant> getVariantAsync(String feature, Object featureContext) {
        return this.checkFeature(feature, featureContext).map(event -> event.getVariant());
    }

    private Mono<EvaluationEvent> checkFeature(String featureName, Object featureContext) throws FilterNotFoundException {
        List<FeatureDefinition> featureFlags = this.featureManagementConfigurations.getFeatureFlags();
        if (featureFlags == null) {
            return Mono.just((Object)new EvaluationEvent(null));
        }
        FeatureDefinition featureFlag = featureFlags.stream().filter(feature -> feature.getId().equals(featureName)).findAny().orElse(null);
        EvaluationEvent event = new EvaluationEvent(featureFlag);
        if (featureFlag == null) {
            LOGGER.warn("Feature flag {} not found", (Object)featureName);
            return Mono.just((Object)event);
        }
        if (!featureFlag.isEnabled()) {
            this.assignDefaultDisabledReason(event);
            event.setEnabled(false);
            this.publishTelemetryIfEnabled(event);
            return Mono.just((Object)event);
        }
        Mono result = this.checkFeatureFilters(event, featureContext);
        result = this.assignAllocation(result);
        result = result.doOnSuccess(resultEvent -> this.publishTelemetryIfEnabled((EvaluationEvent)resultEvent));
        return result;
    }

    private void publishTelemetryIfEnabled(EvaluationEvent event) {
        if (this.telemetryPublisher != null && event.getFeature() != null && event.getFeature().getTelemetry() != null && event.getFeature().getTelemetry().isEnabled()) {
            this.telemetryPublisher.publish(event);
        }
    }

    private Mono<EvaluationEvent> assignAllocation(Mono<EvaluationEvent> monoEvent) {
        return monoEvent.map(event -> {
            FeatureDefinition featureFlag = event.getFeature();
            if (featureFlag.getVariants() == null || featureFlag.getAllocation() == null) {
                return event;
            }
            if (!event.isEnabled()) {
                this.assignDefaultDisabledReason((EvaluationEvent)event);
                return event;
            }
            this.assignVariant((EvaluationEvent)event);
            return event;
        });
    }

    private void assignDefaultDisabledReason(EvaluationEvent event) {
        FeatureDefinition featureFlag = event.getFeature();
        event.setReason(VariantAssignmentReason.DEFAULT_WHEN_DISABLED);
        if (event.getFeature().getAllocation() == null) {
            return;
        }
        this.assignVariantOverride(event.getFeature().getVariants(), event.getFeature().getAllocation().getDefaultWhenDisabled(), false, event);
        if (featureFlag.getAllocation() != null) {
            String variantName = featureFlag.getAllocation().getDefaultWhenDisabled();
            event.setVariant(this.variantNameToVariant(featureFlag, variantName));
        }
    }

    private void assignDefaultEnabledVariant(EvaluationEvent event) {
        event.setReason(VariantAssignmentReason.DEFAULT_WHEN_ENABLED);
        if (event.getFeature().getAllocation() == null) {
            return;
        }
        this.assignVariantOverride(event.getFeature().getVariants(), event.getFeature().getAllocation().getDefaultWhenEnabled(), true, event);
        FeatureDefinition featureFlag = event.getFeature();
        if (featureFlag.getAllocation() != null) {
            event.setVariant(this.variantNameToVariant(featureFlag, featureFlag.getAllocation().getDefaultWhenEnabled()));
            return;
        }
    }

    private void assignVariant(EvaluationEvent event) {
        FeatureDefinition featureFlag = event.getFeature();
        if (featureFlag.getVariants().size() == 0 || featureFlag.getAllocation() == null) {
            return;
        }
        Allocation allocation = featureFlag.getAllocation();
        TargetingFilterContext targetingContext = this.buildContext();
        List<String> groups = targetingContext.getGroups();
        String variantName = null;
        if (StringUtils.hasText((String)targetingContext.getUserId()) && allocation.getUser() != null) {
            for (UserAllocation userAllocation : allocation.getUser()) {
                if (!this.evaluationOptions.isIgnoreCase() && userAllocation.getUsers().contains(targetingContext.getUserId())) {
                    event.setReason(VariantAssignmentReason.USER);
                    variantName = userAllocation.getVariant();
                    break;
                }
                if (!this.evaluationOptions.isIgnoreCase()) continue;
                if (!userAllocation.getUsers().stream().anyMatch(targetingContext.getUserId()::equalsIgnoreCase)) continue;
                event.setReason(VariantAssignmentReason.USER);
                variantName = userAllocation.getVariant();
                break;
            }
        }
        if (variantName == null && allocation.getGroup() != null) {
            for (GroupAllocation groupAllocation : allocation.getGroup()) {
                for (String allocationGroup : groupAllocation.getGroups()) {
                    if (!this.evaluationOptions.isIgnoreCase() && groups.contains(allocationGroup)) {
                        event.setReason(VariantAssignmentReason.GROUP);
                        variantName = groupAllocation.getVariant();
                        break;
                    }
                    if (!this.evaluationOptions.isIgnoreCase()) continue;
                    if (!groups.stream().anyMatch(allocationGroup::equalsIgnoreCase)) continue;
                    event.setReason(VariantAssignmentReason.GROUP);
                    variantName = groupAllocation.getVariant();
                    break;
                }
                if (variantName == null) continue;
                break;
            }
        }
        if (variantName == null) {
            Object seed = allocation.getSeed();
            if (!StringUtils.hasText((String)seed)) {
                seed = "allocation\n" + featureFlag.getId();
            }
            String contextId = targetingContext.getUserId() + "\n" + (String)seed;
            double box = FeatureFilterUtils.isTargetedPercentage(contextId);
            for (PercentileAllocation percentileAllocation : allocation.getPercentile()) {
                Double to = percentileAllocation.getTo();
                if ((box != 100.0 || to != 100.0) && (!(percentileAllocation.getFrom() <= box) || !(box < to))) continue;
                event.setReason(VariantAssignmentReason.PERCENTILE);
                variantName = percentileAllocation.getVariant();
                break;
            }
        }
        if (variantName == null) {
            this.assignDefaultEnabledVariant(event);
            return;
        }
        event.setVariant(this.variantNameToVariant(featureFlag, variantName));
        this.assignVariantOverride(featureFlag.getVariants(), variantName, true, event);
    }

    private void assignVariantOverride(List<VariantReference> variants, String defaultVariantName, boolean status, EvaluationEvent event) {
        if (variants.size() == 0 || !StringUtils.hasText((String)defaultVariantName)) {
            return;
        }
        for (VariantReference variant : variants) {
            if (!variant.getName().equals(defaultVariantName)) continue;
            if ("Enabled".equals(variant.getStatusOverride())) {
                event.setEnabled(true);
                return;
            }
            if (!"Disabled".equals(variant.getStatusOverride())) continue;
            event.setEnabled(false);
            return;
        }
        event.setEnabled(status);
    }

    private Mono<EvaluationEvent> checkFeatureFilters(EvaluationEvent event, Object featureContext) {
        FeatureDefinition featureFlag = event.getFeature();
        Conditions conditions = featureFlag.getConditions();
        List<FeatureFilterEvaluationContext> featureFilters = conditions.getClientFilters();
        if (featureFilters.size() == 0) {
            return Mono.just((Object)event.setEnabled(true));
        }
        event.setEnabled(conditions.getRequirementType().equals("All"));
        ArrayList<Mono<Boolean>> filterResults = new ArrayList<Mono<Boolean>>();
        for (FeatureFilterEvaluationContext featureFilter : featureFilters) {
            String filterName = featureFilter.getName();
            featureFilter.setFeatureName(event.getFeature().getId());
            filterResults.add(this.evaluateFilter(featureFilter, featureContext, filterName));
        }
        if ("All".equals(featureFlag.getConditions().getRequirementType())) {
            return Flux.merge(filterResults).reduce((a, b) -> a != false && b != false).single().map(result -> event.setEnabled((boolean)result));
        }
        return Flux.merge(filterResults).reduce((a, b) -> a != false || b != false).single().map(result -> event.setEnabled((boolean)result));
    }

    private Variant variantNameToVariant(FeatureDefinition featureFlag, String variantName) {
        for (VariantReference variant : featureFlag.getVariants()) {
            if (!variant.getName().equals(variantName)) continue;
            return new Variant(variantName, variant.getConfigurationValue());
        }
        return null;
    }

    private TargetingFilterContext buildContext() {
        TargetingFilterContext targetingContext = new TargetingFilterContext();
        if (this.contextAccessor != null) {
            this.contextAccessor.configureTargetingContext(targetingContext);
            return targetingContext;
        }
        throw new FeatureManagementException("No Targeting Filter Context found to assign variant.");
    }

    public Set<String> getAllFeatureNames() {
        if (this.featureManagementConfigurations == null || this.featureManagementConfigurations.getFeatureFlags() == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(this.featureManagementConfigurations.getFeatureFlags().stream().map(feature -> feature.getId()).toList());
    }

    private Mono<Boolean> evaluateFilter(FeatureFilterEvaluationContext featureFilter, Object featureContext, String filterName) {
        try {
            Object filter = this.context.getBean(filterName);
            if (filter instanceof FeatureFilter) {
                return Mono.just((Object)((FeatureFilter)filter).evaluate(featureFilter));
            }
            if (filter instanceof ContextualFeatureFilter) {
                return Mono.just((Object)((ContextualFeatureFilter)filter).evaluate(featureFilter, featureContext));
            }
            if (filter instanceof FeatureFilterAsync) {
                return ((FeatureFilterAsync)filter).evaluateAsync(featureFilter);
            }
            if (filter instanceof ContextualFeatureFilterAsync) {
                return ((ContextualFeatureFilterAsync)filter).evaluateAsync(featureFilter, featureContext);
            }
            LOGGER.warn("Filter {} does not implement any known filter interface", (Object)filterName);
            return Mono.just((Object)false);
        }
        catch (NoSuchBeanDefinitionException e) {
            LOGGER.error("Was unable to find Filter {}. Does the class exist and set as an @Component?", (Object)filterName, (Object)e);
            if (this.properties.isFailFast()) {
                String message = "Fail fast is set and a Filter was unable to be found";
                return Mono.error((Throwable)new FilterNotFoundException(message, e, featureFilter));
            }
            return Mono.just((Object)false);
        }
    }
}

