/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.feature.management;

import com.azure.spring.cloud.feature.management.filters.FeatureFilter;
import com.azure.spring.cloud.feature.management.implementation.FeatureManagementConfigProperties;
import com.azure.spring.cloud.feature.management.implementation.FeatureManagementProperties;
import com.azure.spring.cloud.feature.management.implementation.models.Feature;
import com.azure.spring.cloud.feature.management.models.FeatureFilterEvaluationContext;
import com.azure.spring.cloud.feature.management.models.FilterNotFoundException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;
import reactor.core.publisher.Mono;

public class FeatureManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureManager.class);
    private transient ApplicationContext context;
    private final FeatureManagementProperties featureManagementConfigurations;
    private transient FeatureManagementConfigProperties properties;

    FeatureManager(ApplicationContext context, FeatureManagementProperties featureManagementConfigurations, FeatureManagementConfigProperties properties) {
        this.context = context;
        this.featureManagementConfigurations = featureManagementConfigurations;
        this.properties = properties;
    }

    public Mono<Boolean> isEnabledAsync(String feature) {
        return Mono.just((Object)this.checkFeature(feature));
    }

    public Boolean isEnabled(String feature) throws FilterNotFoundException {
        return this.checkFeature(feature);
    }

    private boolean checkFeature(String feature) throws FilterNotFoundException {
        if (this.featureManagementConfigurations.getFeatureManagement() == null || this.featureManagementConfigurations.getOnOff() == null) {
            return false;
        }
        Boolean boolFeature = this.featureManagementConfigurations.getOnOff().get(feature);
        if (boolFeature != null) {
            return boolFeature;
        }
        Feature featureItem = this.featureManagementConfigurations.getFeatureManagement().get(feature);
        if (featureItem == null || !featureItem.getEvaluate().booleanValue()) {
            return false;
        }
        Stream<FeatureFilterEvaluationContext> filters = featureItem.getEnabledFor().values().stream().filter(Objects::nonNull).filter(featureFilter -> featureFilter.getName() != null);
        if (featureItem.getRequirementType().equals("All")) {
            return filters.allMatch(featureFilter -> this.isFeatureOn((FeatureFilterEvaluationContext)featureFilter, feature));
        }
        return filters.anyMatch(featureFilter -> this.isFeatureOn((FeatureFilterEvaluationContext)featureFilter, feature));
    }

    private boolean isFeatureOn(FeatureFilterEvaluationContext filter, String feature) {
        try {
            FeatureFilter featureFilter = (FeatureFilter)this.context.getBean(filter.getName());
            filter.setFeatureName(feature);
            return featureFilter.evaluate(filter);
        }
        catch (NoSuchBeanDefinitionException e) {
            LOGGER.error("Was unable to find Filter {}. Does the class exist and set as an @Component?", (Object)filter.getName());
            if (this.properties.isFailFast()) {
                String message = "Fail fast is set and a Filter was unable to be found";
                ReflectionUtils.rethrowRuntimeException((Throwable)new FilterNotFoundException(message, e, filter));
            }
            return false;
        }
    }

    public Set<String> getAllFeatureNames() {
        HashSet<String> allFeatures = new HashSet<String>();
        allFeatures.addAll(this.featureManagementConfigurations.getOnOff().keySet());
        allFeatures.addAll(this.featureManagementConfigurations.getFeatureManagement().keySet());
        return allFeatures;
    }

    Map<String, Feature> getFeatureManagement() {
        return this.featureManagementConfigurations.getFeatureManagement();
    }

    Map<String, Boolean> getOnOff() {
        return this.featureManagementConfigurations.getOnOff();
    }
}

