/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.jdbc;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.extensions.implementation.credential.TokenCredentialProviderOptions;
import com.azure.identity.extensions.implementation.credential.provider.TokenCredentialProvider;
import com.azure.identity.extensions.implementation.enums.AuthProperty;
import com.azure.spring.cloud.autoconfigure.implementation.context.properties.AzureGlobalProperties;
import com.azure.spring.cloud.autoconfigure.implementation.jdbc.DatabaseType;
import com.azure.spring.cloud.autoconfigure.implementation.jdbc.JdbcConnectionString;
import com.azure.spring.cloud.autoconfigure.implementation.jdbc.JdbcConnectionStringEnhancer;
import com.azure.spring.cloud.autoconfigure.implementation.passwordless.properties.AzureJdbcPasswordlessProperties;
import com.azure.spring.cloud.core.implementation.util.AzurePasswordlessPropertiesUtils;
import com.azure.spring.cloud.core.implementation.util.AzureSpringIdentifier;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.core.properties.PasswordlessProperties;
import com.azure.spring.cloud.service.implementation.identity.credential.provider.SpringTokenCredentialProvider;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

class JdbcPropertiesBeanPostProcessor
implements BeanPostProcessor,
EnvironmentAware,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcPropertiesBeanPostProcessor.class);
    private static final String SPRING_TOKEN_CREDENTIAL_PROVIDER_CLASS_NAME = SpringTokenCredentialProvider.class.getName();
    private static final String SPRING_CLOUD_AZURE_DATASOURCE_PREFIX = "spring.datasource.azure";
    private GenericApplicationContext applicationContext;
    private Environment environment;

    JdbcPropertiesBeanPostProcessor() {
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DataSourceProperties) {
            DataSourceProperties dataSourceProperties = (DataSourceProperties)bean;
            AzureJdbcPasswordlessProperties properties = this.buildAzureProperties();
            if (!properties.isPasswordlessEnabled()) {
                LOGGER.debug("Feature passwordless authentication is not enabled, skip enhancing jdbc url.");
                return bean;
            }
            String url = dataSourceProperties.getUrl();
            if (!StringUtils.hasText((String)url)) {
                LOGGER.debug("No 'spring.datasource.url' provided, skip enhancing jdbc url.");
                return bean;
            }
            JdbcConnectionString connectionString = JdbcConnectionString.resolve(url);
            if (connectionString == null) {
                LOGGER.debug("Can not resolve jdbc connection string from provided {}, skip enhancing jdbc url.", (Object)url);
                return bean;
            }
            boolean isPasswordProvided = StringUtils.hasText((String)dataSourceProperties.getPassword());
            if (isPasswordProvided) {
                LOGGER.debug("If you are using Azure hosted services,it is encouraged to use the passwordless feature. Please refer to https://aka.ms/passwordless-connections.");
                return bean;
            }
            DatabaseType databaseType = connectionString.getDatabaseType();
            if (!databaseType.isDatabasePluginAvailable()) {
                LOGGER.debug("The jdbc plugin with provided jdbc schema is not on the classpath, skip enhancing jdbc url.");
                return bean;
            }
            try {
                JdbcConnectionStringEnhancer enhancer = new JdbcConnectionStringEnhancer(connectionString);
                enhancer.enhanceProperties(this.buildEnhancedProperties(databaseType, properties));
                this.enhanceUserAgent(databaseType, enhancer);
                ((DataSourceProperties)bean).setUrl(enhancer.getJdbcUrl());
            }
            catch (IllegalArgumentException e) {
                LOGGER.debug("Inconsistent properties detected, skip enhancing jdbc url.");
            }
        }
        return bean;
    }

    private void enhanceUserAgent(DatabaseType databaseType, JdbcConnectionStringEnhancer enhancer) {
        if (DatabaseType.MYSQL == databaseType) {
            HashMap<String, String> enhancedAttributes = new HashMap<String, String>();
            enhancedAttributes.put("_extension_version", AzureSpringIdentifier.AZURE_SPRING_MYSQL_OAUTH);
            enhancer.enhancePropertyAttributes("connectionAttributes", enhancedAttributes, ",", ":");
        } else if (DatabaseType.POSTGRESQL == databaseType) {
            HashMap<String, String> enhancedProperties = new HashMap<String, String>();
            enhancedProperties.put("ApplicationName", AzureSpringIdentifier.AZURE_SPRING_POSTGRESQL_OAUTH);
            enhancedProperties.put("assumeMinServerVersion", "9.0.0");
            enhancer.enhanceProperties(enhancedProperties, true);
        }
    }

    private Map<String, String> buildEnhancedProperties(DatabaseType databaseType, AzureJdbcPasswordlessProperties properties) {
        HashMap<String, String> result = new HashMap<String, String>();
        TokenCredentialProvider tokenCredentialProvider = TokenCredentialProvider.createDefault((TokenCredentialProviderOptions)new TokenCredentialProviderOptions(properties.toPasswordlessProperties()));
        TokenCredential tokenCredential = (TokenCredential)tokenCredentialProvider.get();
        AuthProperty.TOKEN_CREDENTIAL_BEAN_NAME.setProperty(result, "passwordlessTokenCredential");
        this.applicationContext.registerBean("passwordlessTokenCredential", TokenCredential.class, () -> tokenCredential, new BeanDefinitionCustomizer[0]);
        LOGGER.debug("Add SpringTokenCredentialProvider as the default token credential provider.");
        AuthProperty.TOKEN_CREDENTIAL_PROVIDER_CLASS_NAME.setProperty(result, SPRING_TOKEN_CREDENTIAL_PROVIDER_CLASS_NAME);
        AuthProperty.AUTHORITY_HOST.setProperty(result, properties.getProfile().getEnvironment().getActiveDirectoryEndpoint());
        databaseType.setDefaultEnhancedProperties(result);
        return result;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (GenericApplicationContext)applicationContext;
    }

    private AzureJdbcPasswordlessProperties buildAzureProperties() {
        AzureGlobalProperties azureGlobalProperties = (AzureGlobalProperties)this.applicationContext.getBean(AzureGlobalProperties.class);
        AzureJdbcPasswordlessProperties azurePasswordlessProperties = (AzureJdbcPasswordlessProperties)Binder.get((Environment)this.environment).bindOrCreate(SPRING_CLOUD_AZURE_DATASOURCE_PREFIX, AzureJdbcPasswordlessProperties.class);
        AzureJdbcPasswordlessProperties mergedProperties = new AzureJdbcPasswordlessProperties();
        AzurePasswordlessPropertiesUtils.mergeAzureCommonProperties((AzureProperties)azureGlobalProperties, (PasswordlessProperties)azurePasswordlessProperties, (PasswordlessProperties)mergedProperties);
        return mergedProperties;
    }
}

