/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.properties.utils;

import com.azure.spring.cloud.autoconfigure.implementation.context.properties.AzureGlobalProperties;
import com.azure.spring.cloud.core.implementation.util.AzurePropertiesUtils;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.core.provider.ClientOptionsProvider;
import com.azure.spring.cloud.core.provider.ProxyOptionsProvider;
import com.azure.spring.cloud.core.provider.RetryOptionsProvider;
import org.springframework.beans.BeanUtils;

public final class AzureGlobalPropertiesUtils {
    private AzureGlobalPropertiesUtils() {
    }

    public static <T extends AzureProperties> T loadProperties(AzureGlobalProperties source, T target) {
        RetryOptionsProvider.RetryOptions retry;
        AzurePropertiesUtils.copyAzureCommonProperties((AzureProperties)source, target);
        if (target.getClient() instanceof ClientOptionsProvider.HttpClientOptions) {
            BeanUtils.copyProperties((Object)source.getClient().getHttp(), (Object)target.getClient());
            ClientOptionsProvider.HttpClientOptions targetClient = (ClientOptionsProvider.HttpClientOptions)target.getClient();
            targetClient.getHeaders().addAll(source.getClient().getHttp().getHeaders());
            BeanUtils.copyProperties((Object)source.getClient().getHttp().getLogging(), (Object)targetClient.getLogging());
            targetClient.getLogging().getAllowedHeaderNames().addAll(source.getClient().getHttp().getLogging().getAllowedHeaderNames());
            targetClient.getLogging().getAllowedQueryParamNames().addAll(source.getClient().getHttp().getLogging().getAllowedQueryParamNames());
        } else if (target.getClient() instanceof ClientOptionsProvider.AmqpClientOptions) {
            BeanUtils.copyProperties((Object)source.getClient().getAmqp(), (Object)target.getClient());
        }
        if (target.getProxy() instanceof ProxyOptionsProvider.HttpProxyOptions) {
            BeanUtils.copyProperties((Object)source.getProxy().getHttp(), (Object)target.getProxy());
        } else if (target.getProxy() instanceof ProxyOptionsProvider.AmqpProxyOptions) {
            BeanUtils.copyProperties((Object)source.getProxy().getAmqp(), (Object)target.getProxy());
        }
        if (target instanceof RetryOptionsProvider && (retry = ((RetryOptionsProvider)target).getRetry()) instanceof RetryOptionsProvider.AmqpRetryOptions) {
            BeanUtils.copyProperties((Object)source.getRetry().getAmqp(), (Object)retry);
        }
        return target;
    }
}

