/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.aad.security;

import com.azure.spring.cloud.autoconfigure.implementation.aad.configuration.properties.AadAuthenticationProperties;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.AadClientRegistrationRepository;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.AadJwtClientAuthenticationParametersConverter;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.AadOAuth2AuthorizationCodeGrantRequestEntityConverter;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.AadOAuth2AuthorizationRequestResolver;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.OAuth2ClientAuthenticationJwkResolver;
import com.azure.spring.cloud.autoconfigure.implementation.aad.utils.AadRestTemplateCreator;
import jakarta.servlet.Filter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.config.annotation.SecurityBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.oauth2.client.endpoint.DefaultAuthorizationCodeTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.web.logout.OidcClientInitiatedLogoutSuccessHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestRedirectFilter;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestOperations;

public class AadWebApplicationHttpSecurityConfigurer
extends AbstractHttpConfigurer<AadWebApplicationHttpSecurityConfigurer, HttpSecurity> {
    protected ClientRegistrationRepository repo;
    protected RestTemplateBuilder restTemplateBuilder;
    protected OAuth2UserService<OidcUserRequest, OidcUser> oidcUserService;
    protected AadAuthenticationProperties properties;
    protected ObjectProvider<OAuth2ClientAuthenticationJwkResolver> jwkResolvers;
    private Filter conditionalAccessFilter;

    public void init(HttpSecurity builder) throws Exception {
        super.init((SecurityBuilder)builder);
        ApplicationContext context = (ApplicationContext)builder.getSharedObject(ApplicationContext.class);
        this.repo = (ClientRegistrationRepository)context.getBean(ClientRegistrationRepository.class);
        this.properties = (AadAuthenticationProperties)context.getBean(AadAuthenticationProperties.class);
        this.restTemplateBuilder = (RestTemplateBuilder)context.getBean(RestTemplateBuilder.class);
        ObjectProvider oidcUserServiceProvider = context.getBeanProvider(ResolvableType.forClassWithGenerics(OAuth2UserService.class, (Class[])new Class[]{OidcUserRequest.class, OidcUser.class}));
        this.oidcUserService = (OAuth2UserService)oidcUserServiceProvider.getIfUnique();
        this.jwkResolvers = context.getBeanProvider(OAuth2ClientAuthenticationJwkResolver.class);
        ((HttpSecurity)builder.oauth2Login().authorizationEndpoint().authorizationRequestResolver(this.requestResolver()).and().tokenEndpoint().accessTokenResponseClient(this.accessTokenResponseClient()).and().userInfoEndpoint().oidcUserService(this.oidcUserService).and().and()).logout().logoutSuccessHandler(this.oidcLogoutSuccessHandler());
    }

    public void configure(HttpSecurity builder) throws Exception {
        if (this.conditionalAccessFilter != null) {
            builder.addFilterAfter(this.conditionalAccessFilter, OAuth2AuthorizationRequestRedirectFilter.class);
        }
    }

    public static AadWebApplicationHttpSecurityConfigurer aadWebApplication() {
        return new AadWebApplicationHttpSecurityConfigurer();
    }

    public AadWebApplicationHttpSecurityConfigurer conditionalAccessFilter(Filter conditionalAccessFilter) {
        this.conditionalAccessFilter = conditionalAccessFilter;
        return this;
    }

    protected LogoutSuccessHandler oidcLogoutSuccessHandler() {
        OidcClientInitiatedLogoutSuccessHandler oidcLogoutSuccessHandler = new OidcClientInitiatedLogoutSuccessHandler(this.repo);
        String uri = this.properties.getPostLogoutRedirectUri();
        if (StringUtils.hasText((String)uri)) {
            oidcLogoutSuccessHandler.setPostLogoutRedirectUri(uri);
        }
        return oidcLogoutSuccessHandler;
    }

    protected OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient() {
        DefaultAuthorizationCodeTokenResponseClient result = new DefaultAuthorizationCodeTokenResponseClient();
        result.setRestOperations((RestOperations)AadRestTemplateCreator.createOAuth2AccessTokenResponseClientRestTemplate(this.restTemplateBuilder));
        if (this.repo instanceof AadClientRegistrationRepository) {
            AadOAuth2AuthorizationCodeGrantRequestEntityConverter converter = new AadOAuth2AuthorizationCodeGrantRequestEntityConverter(((AadClientRegistrationRepository)this.repo).getAzureClientAccessTokenScopes());
            OAuth2ClientAuthenticationJwkResolver jwkResolver = (OAuth2ClientAuthenticationJwkResolver)this.jwkResolvers.getIfUnique();
            if (jwkResolver != null) {
                converter.addParametersConverter(new AadJwtClientAuthenticationParametersConverter(jwkResolver::resolve));
            }
            result.setRequestEntityConverter((Converter)converter);
        }
        return result;
    }

    protected OAuth2AuthorizationRequestResolver requestResolver() {
        return new AadOAuth2AuthorizationRequestResolver(this.repo, this.properties);
    }
}

