/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.servicebus;

import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.messaging.servicebus.ServiceBusReceiverAsyncClient;
import com.azure.messaging.servicebus.ServiceBusReceiverClient;
import com.azure.messaging.servicebus.ServiceBusSessionReceiverAsyncClient;
import com.azure.messaging.servicebus.ServiceBusSessionReceiverClient;
import com.azure.spring.cloud.autoconfigure.implementation.condition.ConditionalOnAnyProperty;
import com.azure.spring.cloud.autoconfigure.implementation.servicebus.AzureServiceBusConsumerCondition;
import com.azure.spring.cloud.autoconfigure.implementation.servicebus.properties.AzureServiceBusProperties;
import com.azure.spring.cloud.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.cloud.core.implementation.util.AzureSpringIdentifier;
import com.azure.spring.cloud.core.provider.connectionstring.ServiceConnectionStringProvider;
import com.azure.spring.cloud.core.service.AzureServiceType;
import com.azure.spring.cloud.service.implementation.servicebus.factory.ServiceBusReceiverClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.servicebus.factory.ServiceBusSessionReceiverClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.servicebus.properties.ServiceBusReceiverClientProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnAnyProperty(prefix="spring.cloud.azure.servicebus", name={"entity-name", "consumer.entity-name"})
@Import(value={SessionConsumerClientConfiguration.class, NoneSessionConsumerClientConfiguration.class})
@Conditional(value={AzureServiceBusConsumerCondition.class})
class AzureServiceBusConsumerClientConfiguration {
    AzureServiceBusConsumerClientConfiguration() {
    }

    private static boolean isDedicatedConnection(AzureServiceBusProperties.Consumer consumer) {
        return StringUtils.hasText((String)consumer.getNamespace()) || StringUtils.hasText((String)consumer.getConnectionString());
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"spring.cloud.azure.servicebus.consumer.session-enabled"}, havingValue="true")
    static class SessionConsumerClientConfiguration {
        SessionConsumerClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ServiceBusSessionReceiverClientBuilderFactory serviceBusSessionReceiverClientBuilderFactory(AzureServiceBusProperties serviceBusProperties, ObjectProvider<ServiceBusClientBuilder> serviceBusClientBuilders, ObjectProvider<ServiceConnectionStringProvider<AzureServiceType.ServiceBus>> connectionStringProviders, ObjectProvider<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder>> customizers, ObjectProvider<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder>> sessionReceiverCustomizers) {
            ServiceBusSessionReceiverClientBuilderFactory factory = AzureServiceBusConsumerClientConfiguration.isDedicatedConnection(serviceBusProperties.getConsumer()) ? new ServiceBusSessionReceiverClientBuilderFactory((ServiceBusReceiverClientProperties)serviceBusProperties.buildConsumerProperties(), customizers.orderedStream().toList()) : new ServiceBusSessionReceiverClientBuilderFactory((ServiceBusClientBuilder)serviceBusClientBuilders.getIfAvailable(), (ServiceBusReceiverClientProperties)serviceBusProperties.buildConsumerProperties());
            factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_SERVICE_BUS);
            connectionStringProviders.orderedStream().findFirst().ifPresent(arg_0 -> ((ServiceBusSessionReceiverClientBuilderFactory)factory).setConnectionStringProvider(arg_0));
            sessionReceiverCustomizers.orderedStream().forEach(arg_0 -> ((ServiceBusSessionReceiverClientBuilderFactory)factory).addBuilderCustomizer(arg_0));
            return factory;
        }

        @Bean
        @ConditionalOnMissingBean
        ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder serviceBusSessionReceiverClientBuilder(ServiceBusSessionReceiverClientBuilderFactory builderFactory) {
            return (ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder)builderFactory.build();
        }

        @Bean
        @ConditionalOnMissingBean
        ServiceBusSessionReceiverAsyncClient serviceBusSessionReceiverAsyncClient(ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder receiverClientBuilder) {
            return receiverClientBuilder.buildAsyncClient();
        }

        @Bean
        @ConditionalOnMissingBean
        ServiceBusSessionReceiverClient serviceBusSessionReceiverClient(ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder receiverClientBuilder) {
            return receiverClientBuilder.buildClient();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"spring.cloud.azure.servicebus.consumer.session-enabled"}, havingValue="false", matchIfMissing=true)
    static class NoneSessionConsumerClientConfiguration {
        NoneSessionConsumerClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ServiceBusReceiverClientBuilderFactory serviceBusReceiverClientBuilderFactory(AzureServiceBusProperties serviceBusProperties, ObjectProvider<ServiceBusClientBuilder> serviceBusClientBuilders, ObjectProvider<ServiceConnectionStringProvider<AzureServiceType.ServiceBus>> connectionStringProviders, ObjectProvider<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder>> customizers, ObjectProvider<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusReceiverClientBuilder>> receiverCustomizers) {
            ServiceBusReceiverClientBuilderFactory factory = AzureServiceBusConsumerClientConfiguration.isDedicatedConnection(serviceBusProperties.getConsumer()) ? new ServiceBusReceiverClientBuilderFactory((ServiceBusReceiverClientProperties)serviceBusProperties.buildConsumerProperties(), customizers.orderedStream().toList()) : new ServiceBusReceiverClientBuilderFactory((ServiceBusClientBuilder)serviceBusClientBuilders.getIfAvailable(), (ServiceBusReceiverClientProperties)serviceBusProperties.buildConsumerProperties());
            factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_SERVICE_BUS);
            connectionStringProviders.orderedStream().findFirst().ifPresent(arg_0 -> ((ServiceBusReceiverClientBuilderFactory)factory).setConnectionStringProvider(arg_0));
            receiverCustomizers.orderedStream().forEach(arg_0 -> ((ServiceBusReceiverClientBuilderFactory)factory).addBuilderCustomizer(arg_0));
            return factory;
        }

        @Bean
        @ConditionalOnMissingBean
        ServiceBusClientBuilder.ServiceBusReceiverClientBuilder serviceBusReceiverClientBuilder(ServiceBusReceiverClientBuilderFactory builderFactory) {
            return (ServiceBusClientBuilder.ServiceBusReceiverClientBuilder)builderFactory.build();
        }

        @Bean
        @ConditionalOnMissingBean
        ServiceBusReceiverAsyncClient serviceBusReceiverAsyncClient(ServiceBusClientBuilder.ServiceBusReceiverClientBuilder receiverClientBuilder) {
            return receiverClientBuilder.buildAsyncClient();
        }

        @Bean
        @ConditionalOnMissingBean
        ServiceBusReceiverClient serviceBusReceiverClient(ServiceBusClientBuilder.ServiceBusReceiverClientBuilder receiverClientBuilder) {
            return receiverClientBuilder.buildClient();
        }
    }
}

