/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation.properties;

import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class FeatureFlagKeyValueSelector {
    private static final String[] EMPTY_LABEL_ARRAY = new String[]{"\u0000"};
    private String keyFilter = "";
    private String labelFilter;

    public String getKeyFilter() {
        return this.keyFilter;
    }

    public FeatureFlagKeyValueSelector setKeyFilter(String keyFilter) {
        this.keyFilter = keyFilter;
        return this;
    }

    public String[] getLabelFilter(List<String> profiles) {
        if (this.labelFilter == null && profiles.size() > 0) {
            Collections.reverse(profiles);
            return profiles.toArray(new String[profiles.size()]);
        }
        if (!StringUtils.hasText((String)this.labelFilter)) {
            return EMPTY_LABEL_ARRAY;
        }
        List<String> labels = Arrays.stream(this.labelFilter.split(",")).map(this::mapLabel).distinct().collect(Collectors.toList());
        if (this.labelFilter.endsWith(",")) {
            labels.add("\u0000");
        }
        Collections.reverse(labels);
        String[] t = new String[labels.size()];
        return labels.toArray(t);
    }

    public String getLabelFilterText(List<String> profiles) {
        return String.join((CharSequence)",", this.getLabelFilter(profiles));
    }

    public FeatureFlagKeyValueSelector setLabelFilter(String labelFilter) {
        this.labelFilter = labelFilter;
        return this;
    }

    @PostConstruct
    void validateAndInit() {
        if (this.labelFilter != null) {
            Assert.isTrue((!this.labelFilter.contains("*") ? 1 : 0) != 0, (String)"LabelFilter must not contain asterisk(*)");
        }
    }

    private String mapLabel(String label) {
        if (label == null || "".equals(label) || "\u0000".equals(label)) {
            return "\u0000";
        }
        return label.trim();
    }
}

