/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation.feature.entity;

import com.azure.data.appconfiguration.models.FeatureFlagConfigurationSetting;
import com.azure.spring.cloud.appconfiguration.config.implementation.feature.entity.Allocation;
import com.azure.spring.cloud.appconfiguration.config.implementation.feature.entity.Conditions;
import com.azure.spring.cloud.appconfiguration.config.implementation.feature.entity.FeatureTelemetry;
import com.azure.spring.cloud.appconfiguration.config.implementation.feature.entity.Variant;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class Feature {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="enabled")
    private boolean enabled;
    @JsonProperty(value="conditions")
    private Conditions conditions;
    @JsonProperty(value="variants")
    private List<Variant> variants;
    @JsonProperty(value="allocation")
    private Allocation allocation;
    @JsonProperty(value="telemetry")
    private FeatureTelemetry telemetry;

    public Feature() {
    }

    public Feature(FeatureFlagConfigurationSetting featureFlag, String requirementType, FeatureTelemetry telemetry) {
        this.id = featureFlag.getFeatureId();
        this.description = featureFlag.getDescription();
        this.enabled = featureFlag.isEnabled();
        this.conditions = new Conditions(featureFlag.getClientFilters(), requirementType);
        this.setTelemetry(telemetry);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
    }

    public List<Variant> getVariants() {
        return this.variants;
    }

    public void setVariants(List<Variant> variants) {
        this.variants = variants;
    }

    public Allocation getAllocation() {
        return this.allocation;
    }

    public void setAllocation(Allocation allocation) {
        this.allocation = allocation;
    }

    public FeatureTelemetry getTelemetry() {
        return this.telemetry;
    }

    public void setTelemetry(FeatureTelemetry telemetry) {
        this.telemetry = telemetry;
    }
}

