/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.spring.cloud.appconfiguration.config.implementation.properties.AppConfigurationKeyValueSelector;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.AppConfigurationStoreMonitoring;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.ConfigStore;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.FeatureFlagKeyValueSelector;
import java.time.Duration;
import java.util.List;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.config.Profiles;

public class AzureAppConfigDataResource
extends ConfigDataResource {
    private final boolean configStoreEnabled;
    private final String endpoint;
    private final List<String> trimKeyPrefix;
    private final Profiles profiles;
    private final List<AppConfigurationKeyValueSelector> selects;
    private final List<FeatureFlagKeyValueSelector> featureFlagSelects;
    private final AppConfigurationStoreMonitoring monitoring;
    private final boolean isRefresh;
    private final Duration refreshInterval;

    AzureAppConfigDataResource(ConfigStore configStore, Profiles profiles, boolean isRefresh, Duration refreshInterval) {
        this.configStoreEnabled = configStore.isEnabled();
        this.endpoint = configStore.getEndpoint();
        this.selects = configStore.getSelects();
        this.featureFlagSelects = configStore.getFeatureFlags().getSelects();
        this.trimKeyPrefix = configStore.getTrimKeyPrefix();
        this.monitoring = configStore.getMonitoring();
        this.profiles = profiles;
        this.isRefresh = isRefresh;
        this.refreshInterval = refreshInterval;
    }

    public List<AppConfigurationKeyValueSelector> getSelects() {
        return this.selects;
    }

    public List<FeatureFlagKeyValueSelector> getFeatureFlagSelects() {
        return this.featureFlagSelects;
    }

    public boolean isConfigStoreEnabled() {
        return this.configStoreEnabled;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public AppConfigurationStoreMonitoring getMonitoring() {
        return this.monitoring;
    }

    public List<String> getTrimKeyPrefix() {
        return this.trimKeyPrefix;
    }

    public Profiles getProfiles() {
        return this.profiles;
    }

    public boolean isRefresh() {
        return this.isRefresh;
    }

    public Duration getRefreshInterval() {
        return this.refreshInterval;
    }
}

