/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.spring.cloud.appconfiguration.config.KeyVaultSecretProvider;
import com.azure.spring.cloud.appconfiguration.config.SecretClientCustomizer;
import com.azure.spring.cloud.appconfiguration.config.implementation.stores.AppConfigurationSecretClientManager;
import com.azure.spring.cloud.service.implementation.keyvault.secrets.SecretClientBuilderFactory;
import java.util.HashMap;
import java.util.Map;

class AppConfigurationKeyVaultClientFactory {
    private final Map<String, AppConfigurationSecretClientManager> keyVaultClients;
    private final SecretClientCustomizer keyVaultClientProvider;
    private final KeyVaultSecretProvider keyVaultSecretProvider;
    private final SecretClientBuilderFactory secretClientFactory;
    private final boolean credentialsConfigured;
    private final boolean isConfigured;

    AppConfigurationKeyVaultClientFactory(SecretClientCustomizer keyVaultClientProvider, KeyVaultSecretProvider keyVaultSecretProvider, SecretClientBuilderFactory secretClientFactory, boolean credentialsConfigured) {
        this.keyVaultClientProvider = keyVaultClientProvider;
        this.keyVaultSecretProvider = keyVaultSecretProvider;
        this.secretClientFactory = secretClientFactory;
        this.keyVaultClients = new HashMap<String, AppConfigurationSecretClientManager>();
        this.credentialsConfigured = credentialsConfigured;
        this.isConfigured = keyVaultClientProvider != null || credentialsConfigured;
    }

    AppConfigurationSecretClientManager getClient(String host) {
        if (!this.keyVaultClients.containsKey(host)) {
            AppConfigurationSecretClientManager client = new AppConfigurationSecretClientManager(host, this.keyVaultClientProvider, this.keyVaultSecretProvider, this.secretClientFactory, this.credentialsConfigured);
            this.keyVaultClients.put(host, client);
        }
        return this.keyVaultClients.get(host);
    }

    boolean isConfigured() {
        return this.isConfigured;
    }
}

