/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config;

import com.azure.spring.cloud.appconfiguration.config.AppConfigurationRefresh;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationPullRefresh;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationRefreshUtil;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClientFactory;
import com.azure.spring.cloud.appconfiguration.config.implementation.autofailover.ReplicaLookUp;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.AppConfigurationProperties;
import org.springframework.boot.BootstrapContext;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.endpoint.RefreshEndpoint;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableAsync;

@EnableAsync
@ConditionalOnProperty(prefix="spring.cloud.azure.appconfiguration", name={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={AppConfigurationProperties.class})
@AutoConfiguration
@ConditionalOnClass(value={RefreshEndpoint.class})
public class AppConfigurationWatchAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    AppConfigurationRefresh appConfigurationRefresh(AppConfigurationProperties properties, BootstrapContext context) {
        AppConfigurationReplicaClientFactory clientFactory = (AppConfigurationReplicaClientFactory)context.get(AppConfigurationReplicaClientFactory.class);
        ReplicaLookUp replicaLookUp = (ReplicaLookUp)context.get(ReplicaLookUp.class);
        return new AppConfigurationPullRefresh(clientFactory, properties.getRefreshInterval(), replicaLookUp, new AppConfigurationRefreshUtil());
    }
}

