/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation.autofailover;

import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClientsBuilder;
import com.azure.spring.cloud.appconfiguration.config.implementation.autofailover.SRVRecord;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.AppConfigurationProperties;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.ConfigStore;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ReplicaLookUp {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplicaLookUp.class);
    private static final String ORIGIN_PREFIX = "dns:/_origin._tcp.";
    private static final String REPLICA_PREFIX_ALT = "dns:/_alt";
    private static final String REPLICA_PREFIX_TCP = "._tcp.";
    private static final String SRC_RECORD = "SRV";
    private static final String[] TRUSTED_DOMAIN_LABELS = new String[]{"azconfig", "appconfig"};
    private static final Duration FALLBACK_CLIENT_REFRESH_EXPIRED_INTERVAL = Duration.ofHours(1L);
    private static final Duration MINIMAL_CLIENT_REFRESH_INTERVAL = Duration.ofSeconds(30L);
    InitialDirContext context;
    private Map<String, List<SRVRecord>> records = new HashMap<String, List<SRVRecord>>();
    private Map<String, Instant> wait = new HashMap<String, Instant>();
    private final AppConfigurationProperties properties;
    private final Semaphore semaphore;

    public ReplicaLookUp(AppConfigurationProperties properties) throws NamingException {
        this.properties = properties;
        this.context = new InitialDirContext();
        this.semaphore = new Semaphore(1);
    }

    @Async
    public void updateAutoFailoverEndpoints() {
        if (this.semaphore.tryAcquire()) {
            for (ConfigStore configStore : this.properties.getStores()) {
                if (!configStore.isEnabled() || !configStore.isReplicaDiscoveryEnabled()) continue;
                String mainEndpoint = configStore.getEndpoint();
                List<Object> providedEndpoints = new ArrayList();
                providedEndpoints = configStore.getConnectionStrings().size() > 0 ? configStore.getConnectionStrings().stream().map(connectionString -> AppConfigurationReplicaClientsBuilder.getEndpointFromConnectionString(connectionString)).toList() : (configStore.getEndpoints().size() > 0 ? configStore.getEndpoints() : List.of(configStore.getEndpoint()));
                try {
                    List<SRVRecord> srvRecords = this.findAutoFailoverEndpoints(mainEndpoint, providedEndpoints);
                    srvRecords.sort((a, b) -> a.compareTo((SRVRecord)b));
                    this.records.put(mainEndpoint, srvRecords);
                    this.wait.put(mainEndpoint, Instant.now().plus(FALLBACK_CLIENT_REFRESH_EXPIRED_INTERVAL));
                }
                catch (AppConfigurationReplicaException e) {
                    LOGGER.warn("Failed to finde replicas due to: " + e.getMessage());
                    this.wait.put(mainEndpoint, Instant.now().plus(MINIMAL_CLIENT_REFRESH_INTERVAL));
                }
            }
            this.semaphore.release();
        }
    }

    public List<String> getAutoFailoverEndpoints(String mainEndpoint) {
        List<SRVRecord> endpointRecords = this.records.get(mainEndpoint);
        if (endpointRecords == null) {
            return List.of();
        }
        return endpointRecords.stream().map(record -> record.getEndpoint()).toList();
    }

    private List<SRVRecord> findAutoFailoverEndpoints(String endpoint, List<String> providedEndpoints) throws AppConfigurationReplicaException {
        ArrayList<SRVRecord> records = new ArrayList<SRVRecord>();
        String host = "";
        try {
            URI uri = new URI(endpoint);
            host = uri.getHost();
        }
        catch (URISyntaxException e) {
            return new ArrayList<SRVRecord>();
        }
        SRVRecord origin = this.getOriginRecord(host);
        if (origin != null) {
            List<SRVRecord> replicas = this.getReplicaRecords(origin);
            String knownDomain = this.getKnownDomain(endpoint);
            if (!providedEndpoints.contains(origin.getEndpoint()) && this.validate(knownDomain, origin.getEndpoint())) {
                records.add(origin);
            }
            replicas.stream().forEach(replica -> {
                if (!providedEndpoints.contains(replica.getEndpoint()) && this.validate(knownDomain, replica.getEndpoint())) {
                    records.add((SRVRecord)replica);
                }
            });
        }
        return records;
    }

    private SRVRecord getOriginRecord(String url) throws AppConfigurationReplicaException {
        Attribute attribute = this.requestRecord(ORIGIN_PREFIX + url);
        if (attribute != null) {
            return this.parseHosts(attribute).get(0);
        }
        return null;
    }

    private List<SRVRecord> getReplicaRecords(SRVRecord origin) throws AppConfigurationReplicaException {
        Attribute attribute;
        ArrayList<SRVRecord> replicas = new ArrayList<SRVRecord>();
        int i = 0;
        while ((attribute = this.requestRecord(REPLICA_PREFIX_ALT + i + REPLICA_PREFIX_TCP + origin.getTarget())) != null) {
            replicas.addAll(this.parseHosts(attribute));
            ++i;
        }
        return replicas;
    }

    private Attribute requestRecord(String name) throws AppConfigurationReplicaException {
        Instant retryTime = Instant.now().plusSeconds(30L);
        while (retryTime.isAfter(Instant.now())) {
            try {
                return this.context.getAttributes(name, new String[]{SRC_RECORD}).get(SRC_RECORD);
            }
            catch (NameNotFoundException e) {
                return null;
            }
            catch (NamingException namingException) {
            }
        }
        throw new AppConfigurationReplicaException();
    }

    private List<SRVRecord> parseHosts(Attribute attribute) {
        ArrayList<SRVRecord> hosts = new ArrayList<SRVRecord>();
        try {
            NamingEnumeration<?> records = attribute.getAll();
            while (records.hasMore()) {
                hosts.add(new SRVRecord(((String)records.next()).toString().split(" ")));
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return hosts;
    }

    private boolean validate(String knownDomain, String endpoint) {
        if (!StringUtils.hasText((String)endpoint)) {
            return false;
        }
        if (!StringUtils.hasText((String)knownDomain)) {
            return false;
        }
        return endpoint.endsWith(knownDomain);
    }

    private String getKnownDomain(String knownHost) {
        for (String label : TRUSTED_DOMAIN_LABELS) {
            int index = knownHost.toLowerCase().indexOf("." + label + ".");
            if (index <= 0) continue;
            return knownHost.substring(index);
        }
        return "";
    }

    private class AppConfigurationReplicaException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private AppConfigurationReplicaException() {
        }
    }
}

