/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.core.util.Context;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.FeatureFlagConfigurationSetting;
import com.azure.data.appconfiguration.models.FeatureFlagFilter;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClient;
import com.azure.spring.cloud.appconfiguration.config.implementation.feature.FeatureFlags;
import com.azure.spring.cloud.appconfiguration.config.implementation.feature.entity.Feature;
import com.azure.spring.cloud.appconfiguration.config.implementation.feature.entity.FeatureTelemetry;
import com.azure.spring.cloud.appconfiguration.config.implementation.http.policy.FeatureFlagTracing;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
class FeatureFlagClient {
    private final Map<String, Feature> properties = new LinkedHashMap<String, Feature>();
    private static final ObjectMapper CASE_INSENSITIVE_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).build();
    private FeatureFlagTracing tracing = new FeatureFlagTracing();

    FeatureFlagClient() {
    }

    List<FeatureFlags> loadFeatureFlags(AppConfigurationReplicaClient replicaClient, String customKeyFilter, String[] labelFilter, Context context) {
        ArrayList<FeatureFlags> loadedFeatureFlags = new ArrayList<FeatureFlags>();
        Object keyFilter = ".appconfig.featureflag/*";
        if (StringUtils.hasText((String)customKeyFilter)) {
            keyFilter = ".appconfig.featureflag/" + customKeyFilter;
        }
        List<String> labels = Arrays.asList(labelFilter);
        Collections.reverse(labels);
        for (String label : labels) {
            SettingSelector settingSelector = new SettingSelector().setKeyFilter((String)keyFilter).setLabelFilter(label);
            context.addData((Object)"FeatureFlagTracing", (Object)this.tracing);
            FeatureFlags features = replicaClient.listFeatureFlags(settingSelector, context);
            loadedFeatureFlags.addAll(this.proccessFeatureFlags(features, replicaClient.getOriginClient()));
        }
        return loadedFeatureFlags;
    }

    List<FeatureFlags> proccessFeatureFlags(FeatureFlags features, String endpoint) {
        ArrayList<FeatureFlags> loadedFeatureFlags = new ArrayList<FeatureFlags>();
        loadedFeatureFlags.add(features);
        for (ConfigurationSetting setting : features.getFeatureFlags()) {
            if (!(setting instanceof FeatureFlagConfigurationSetting) || !"application/vnd.microsoft.appconfig.ff+json;charset=utf-8".equals(setting.getContentType())) continue;
            FeatureFlagConfigurationSetting featureFlag = (FeatureFlagConfigurationSetting)setting;
            this.updateTelemetry(featureFlag);
            this.properties.put(featureFlag.getKey(), FeatureFlagClient.createFeature(featureFlag, endpoint));
        }
        return loadedFeatureFlags;
    }

    protected static Feature createFeature(FeatureFlagConfigurationSetting item, String originEndpoint) {
        String requirementType = "Any";
        FeatureTelemetry featureTelemetry = null;
        Feature feature = null;
        try {
            FeatureTelemetry telemetry;
            JsonNode telemetryNode;
            JsonNode node = CASE_INSENSITIVE_MAPPER.readTree(item.getValue());
            JsonNode conditions = node.get("conditions");
            if (conditions != null && conditions.get("requirement_type") != null) {
                requirementType = conditions.get("requirement_type").asText();
            }
            if ((telemetryNode = node.get("telemetry")) != null && !telemetryNode.isEmpty()) {
                ObjectMapper objectMapper = ((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).build();
                featureTelemetry = (FeatureTelemetry)objectMapper.convertValue((Object)telemetryNode, FeatureTelemetry.class);
            }
            if ((feature = new Feature(item, requirementType, featureTelemetry)).getTelemetry() != null && (telemetry = feature.getTelemetry()).isEnabled()) {
                Map<String, String> originMetadata = telemetry.getMetadata();
                originMetadata.put("ETag", item.getETag());
                if (originEndpoint != null && !originEndpoint.isEmpty()) {
                    String labelPart = item.getLabel().isEmpty() ? "" : String.format("?label=%s", item.getLabel());
                    originMetadata.put("FeatureFlagReference", String.format("%s/kv/%s%s", originEndpoint, item.getKey(), labelPart));
                }
                originMetadata.put("AllocationId", FeatureFlagClient.generateAllocationId(node));
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return feature;
    }

    public List<Feature> getFeatureFlags() {
        return this.properties.values().stream().toList();
    }

    public void resetTelemetry() {
        this.tracing.resetFeatureFilterTelemetry();
    }

    private void updateTelemetry(FeatureFlagConfigurationSetting featureFlag) {
        for (FeatureFlagFilter filter : featureFlag.getClientFilters()) {
            this.tracing.updateFeatureFilterTelemetry(filter.getName());
        }
    }

    static String generateAllocationId(JsonNode featureFlagValue) {
        StringBuilder allocationId = new StringBuilder();
        ArrayList<String> allocatedVariants = new ArrayList<String>();
        JsonNode allocation = featureFlagValue.get("allocation");
        if (allocation == null) {
            return null;
        }
        allocationId.append("seed=").append(allocation.has("seed") ? allocation.get("seed").asText() : "");
        if (allocation.has("default_when_enabled")) {
            allocatedVariants.add(allocation.get("default_when_enabled").asText());
        }
        allocationId.append("\ndefault_when_enabled=").append(allocation.has("default_when_enabled") ? allocation.get("default_when_enabled").asText() : "");
        allocationId.append("\npercentiles=");
        JsonNode percentile = allocation.get("percentile");
        ArrayList<JsonNode> percentileAllocations = new ArrayList<JsonNode>();
        if (percentile != null && percentile.isArray()) {
            percentile.forEach(p -> {
                if (!Objects.equals(p.get("from").asText(), p.get("to").asText())) {
                    percentileAllocations.add((JsonNode)p);
                }
            });
            percentileAllocations.sort(Comparator.comparing(p -> p.get("from").asInt()));
        }
        for (JsonNode percentileAllocation : percentileAllocations) {
            if (!percentileAllocation.has("variant")) continue;
            allocatedVariants.add(percentileAllocation.get("variant").asText());
        }
        allocationId.append(percentileAllocations.stream().map(pa -> String.valueOf(pa.get("from")) + "," + Base64.getEncoder().encodeToString(pa.get("variant").asText().getBytes(StandardCharsets.UTF_8)) + "," + String.valueOf(pa.get("to"))).collect(Collectors.joining(";")));
        if (allocatedVariants.isEmpty() && allocation.get("seed") == null) {
            return null;
        }
        allocationId.append("\nvariants=");
        ArrayList variantsValue = new ArrayList();
        JsonNode variantsNode = featureFlagValue.get("variants");
        if (variantsNode != null && variantsNode.isArray()) {
            variantsNode.forEach(variantNode -> {
                if (variantNode.isObject()) {
                    LinkedHashMap variantMap = new LinkedHashMap();
                    variantNode.fields().forEachRemaining(entry -> variantMap.put((String)entry.getKey(), entry.getValue()));
                    variantsValue.add(variantMap);
                }
            });
        }
        if (variantsValue != null && !variantsValue.isEmpty()) {
            List sortedVariants = variantsValue.stream().filter(v -> allocatedVariants.contains(v.get("name"))).sorted(Comparator.comparing(v -> (String)v.get("name"))).collect(Collectors.toList());
            for (Map variant : sortedVariants) {
                allocationId.append(Base64.getEncoder().encodeToString(((String)variant.get("name")).getBytes(StandardCharsets.UTF_8))).append(",");
                Object configValue = variant.get("configuration_value");
                if (configValue instanceof Map) {
                    Map configMap = (Map)configValue;
                    allocationId.append(new TreeMap(configMap).toString());
                }
                allocationId.append(";");
            }
            if (!sortedVariants.isEmpty()) {
                allocationId.setLength(allocationId.length() - 1);
            }
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = digest.digest(allocationId.toString().getBytes(StandardCharsets.UTF_8));
            return Base64.getUrlEncoder().withoutPadding().encodeToString(Arrays.copyOf(hashBytes, 15));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 algorithm not available", e);
        }
    }
}

