/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.core.util.Context;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationApplicationSettingPropertySource;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationFeatureManagementPropertySource;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationKeyVaultClientFactory;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationPropertySource;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationRefreshUtil;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClient;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClientFactory;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationSnapshotPropertySource;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationStatusException;
import com.azure.spring.cloud.appconfiguration.config.implementation.AzureAppConfigDataResource;
import com.azure.spring.cloud.appconfiguration.config.implementation.FeatureFlagClient;
import com.azure.spring.cloud.appconfiguration.config.implementation.StateHolder;
import com.azure.spring.cloud.appconfiguration.config.implementation.feature.FeatureFlags;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.AppConfigurationKeyValueSelector;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.AppConfigurationStoreMonitoring;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.FeatureFlagKeyValueSelector;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.util.StringUtils;

public class AzureAppConfigDataLoader
implements ConfigDataLoader<AzureAppConfigDataResource> {
    private static Log logger = new DeferredLog();
    private AzureAppConfigDataResource resource;
    private AppConfigurationReplicaClientFactory replicaClientFactory;
    private AppConfigurationKeyVaultClientFactory keyVaultClientFactory;
    private StateHolder storeState = new StateHolder();
    private FeatureFlagClient featureFlagClient;
    private Context requestContext;
    private static final Instant START_DATE = Instant.now();
    private static final Integer PREKILL_TIME = 5;

    public AzureAppConfigDataLoader(DeferredLogFactory logFactory) {
        logger = logFactory.getLog(this.getClass());
    }

    public ConfigData load(ConfigDataLoaderContext context, AzureAppConfigDataResource resource) throws IOException, ConfigDataResourceNotFoundException {
        this.resource = resource;
        this.storeState.setNextForcedRefresh(resource.getRefreshInterval());
        if (context.getBootstrapContext().isRegistered(FeatureFlagClient.class)) {
            this.featureFlagClient = (FeatureFlagClient)context.getBootstrapContext().get(FeatureFlagClient.class);
        } else {
            this.featureFlagClient = new FeatureFlagClient();
            context.getBootstrapContext().registerIfAbsent(FeatureFlagClient.class, BootstrapRegistry.InstanceSupplier.from(() -> this.featureFlagClient));
        }
        this.featureFlagClient.resetTelemetry();
        ArrayList<EnumerablePropertySource> sourceList = new ArrayList<EnumerablePropertySource>();
        if (resource.isConfigStoreEnabled()) {
            this.replicaClientFactory = (AppConfigurationReplicaClientFactory)context.getBootstrapContext().get(AppConfigurationReplicaClientFactory.class);
            this.keyVaultClientFactory = (AppConfigurationKeyVaultClientFactory)context.getBootstrapContext().get(AppConfigurationKeyVaultClientFactory.class);
            List<AppConfigurationReplicaClient> clients = this.replicaClientFactory.getAvailableClients(resource.getEndpoint(), true);
            boolean reloadFailed = false;
            boolean pushRefresh = false;
            Object lastException = null;
            AppConfigurationStoreMonitoring.PushNotification notification = resource.getMonitoring().getPushNotification();
            if (notification.getPrimaryToken() != null && StringUtils.hasText((String)notification.getPrimaryToken().getName()) || notification.getSecondaryToken() != null && StringUtils.hasText((String)notification.getPrimaryToken().getName())) {
                pushRefresh = true;
            }
            this.requestContext = new Context((Object)"refresh", (Object)resource.isRefresh()).addData((Object)"PushRefresh", (Object)pushRefresh);
            Iterator<AppConfigurationReplicaClient> clientIterator = clients.iterator();
            while (clientIterator.hasNext()) {
                AppConfigurationReplicaClient client = clientIterator.next();
                if (reloadFailed && !AppConfigurationRefreshUtil.refreshStoreCheck(client, this.replicaClientFactory.findOriginForEndpoint(client.getEndpoint()), this.requestContext)) continue;
                try {
                    sourceList.addAll(this.createSettings(client));
                    List<FeatureFlags> featureFlags = this.createFeatureFlags(client);
                    logger.debug((Object)"PropertySource context.");
                    AppConfigurationStoreMonitoring monitoring = resource.getMonitoring();
                    this.storeState.setStateFeatureFlag(resource.getEndpoint(), featureFlags, monitoring.getFeatureFlagRefreshInterval());
                    if (monitoring.isEnabled()) {
                        List<ConfigurationSetting> watchKeysSettings = monitoring.getTriggers().stream().map(trigger -> client.getWatchKey(trigger.getKey(), trigger.getLabel(), this.requestContext)).toList();
                        this.storeState.setState(resource.getEndpoint(), watchKeysSettings, monitoring.getRefreshInterval());
                    }
                    this.storeState.setLoadState(resource.getEndpoint(), true);
                    lastException = null;
                    break;
                }
                catch (AppConfigurationStatusException e) {
                    reloadFailed = true;
                    this.replicaClientFactory.backoffClient(resource.getEndpoint(), client.getEndpoint());
                    lastException = e;
                    this.logReplicaFailure(client, "status exception", clientIterator.hasNext(), (Exception)((Object)e));
                }
                catch (Exception e) {
                    lastException = e;
                    this.logReplicaFailure(client, "exception", clientIterator.hasNext(), e);
                }
            }
            if (lastException != null && !resource.isRefresh()) {
                logger.error((Object)("Azure App Configuration failed to load configuration during startup for store: " + resource.getEndpoint() + ". Application cannot start without required configuration."));
                this.failedToGeneratePropertySource((Exception)lastException);
            } else if (lastException != null && resource.isRefresh()) {
                logger.warn((Object)("Azure App Configuration failed during refresh for store: " + resource.getEndpoint() + ". Continuing with existing configuration."));
            }
        }
        StateHolder.updateState(this.storeState);
        if (this.featureFlagClient.getFeatureFlags().size() > 0) {
            sourceList.add(new AppConfigurationFeatureManagementPropertySource(this.featureFlagClient));
        }
        return new ConfigData(sourceList, new ConfigData.Option[0]);
    }

    private void failedToGeneratePropertySource(Exception e) {
        logger.error((Object)("Configuration loading failed during application startup from Azure App Configuration store " + this.resource.getEndpoint() + ". Application cannot start without required configuration."));
        this.delayException();
        throw new RuntimeException("Failed to generate property sources for " + this.resource.getEndpoint(), e);
    }

    private List<AppConfigurationPropertySource> createSettings(AppConfigurationReplicaClient client) throws Exception {
        ArrayList<AppConfigurationPropertySource> sourceList = new ArrayList<AppConfigurationPropertySource>();
        List<AppConfigurationKeyValueSelector> selects = this.resource.getSelects();
        List profiles = this.resource.getProfiles().getActive();
        for (AppConfigurationKeyValueSelector selectedKeys : selects) {
            AppConfigurationApplicationSettingPropertySource propertySource = null;
            propertySource = StringUtils.hasText((String)selectedKeys.getSnapshotName()) ? new AppConfigurationSnapshotPropertySource(selectedKeys.getSnapshotName() + "/" + this.resource.getEndpoint(), client, this.keyVaultClientFactory, selectedKeys.getSnapshotName(), this.featureFlagClient) : new AppConfigurationApplicationSettingPropertySource(selectedKeys.getKeyFilter() + this.resource.getEndpoint() + "/", client, this.keyVaultClientFactory, selectedKeys.getKeyFilter(), selectedKeys.getLabelFilter(profiles));
            ((AppConfigurationPropertySource)propertySource).initProperties(this.resource.getTrimKeyPrefix(), this.requestContext);
            sourceList.add(propertySource);
        }
        return sourceList;
    }

    private List<FeatureFlags> createFeatureFlags(AppConfigurationReplicaClient client) throws Exception {
        ArrayList<FeatureFlags> featureFlagWatchKeys = new ArrayList<FeatureFlags>();
        List profiles = this.resource.getProfiles().getActive();
        for (FeatureFlagKeyValueSelector selectedKeys : this.resource.getFeatureFlagSelects()) {
            List<FeatureFlags> storesFeatureFlags = this.featureFlagClient.loadFeatureFlags(client, selectedKeys.getKeyFilter(), selectedKeys.getLabelFilter(profiles), this.requestContext);
            featureFlagWatchKeys.addAll(storesFeatureFlags);
        }
        return featureFlagWatchKeys;
    }

    private void logReplicaFailure(AppConfigurationReplicaClient client, String exceptionType, boolean hasMoreReplicas, Exception exception) {
        String scenario = this.resource.isRefresh() ? "refresh" : "startup";
        String nextAction = hasMoreReplicas ? "Trying next replica." : "No more replicas available.";
        logger.warn((Object)("Azure App Configuration replica " + client.getEndpoint() + " failed during " + scenario + " with " + exceptionType + ". " + nextAction + " Store: " + this.resource.getEndpoint()), (Throwable)exception);
    }

    private void delayException() {
        Instant preKillTime;
        Instant currentDate = Instant.now();
        if (currentDate.isBefore(preKillTime = START_DATE.plusSeconds(PREKILL_TIME.intValue()))) {
            long diffInMillies = Math.abs(preKillTime.toEpochMilli() - currentDate.toEpochMilli());
            try {
                Thread.sleep(diffInMillies);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

