/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.spring.cloud.appconfiguration.config.implementation.FeatureFlagClient;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.List;
import org.springframework.core.env.EnumerablePropertySource;

class AppConfigurationFeatureManagementPropertySource
extends EnumerablePropertySource<FeatureFlagClient> {
    private final FeatureFlagClient featureFlagLoader;
    private static final String FEATURE_MANAGEMENT_KEY = "feature-management";
    private static final ObjectMapper MAPPER = JsonMapper.builder().build();
    private static final String FEATURE_FLAG_KEY = "feature-management.feature-flags";

    AppConfigurationFeatureManagementPropertySource(FeatureFlagClient featureFlagLoader) {
        super(FEATURE_MANAGEMENT_KEY, (Object)featureFlagLoader);
        this.featureFlagLoader = featureFlagLoader;
    }

    public String[] getPropertyNames() {
        if (this.featureFlagLoader != null && this.featureFlagLoader.getFeatureFlags() != null && !this.featureFlagLoader.getFeatureFlags().isEmpty()) {
            return new String[]{FEATURE_FLAG_KEY};
        }
        return new String[0];
    }

    public Object getProperty(String name) {
        if (FEATURE_FLAG_KEY.equals(name)) {
            return MAPPER.convertValue(this.featureFlagLoader.getFeatureFlags(), List.class);
        }
        return null;
    }
}

