/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation.stores;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.azure.security.keyvault.secrets.SecretAsyncClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.azure.spring.cloud.appconfiguration.config.KeyVaultSecretProvider;
import com.azure.spring.cloud.appconfiguration.config.SecretClientCustomizer;
import com.azure.spring.cloud.service.implementation.keyvault.secrets.SecretClientBuilderFactory;
import java.net.URI;
import java.time.Duration;
import org.springframework.util.StringUtils;

public final class AppConfigurationSecretClientManager {
    private SecretAsyncClient secretClient;
    private final SecretClientCustomizer keyVaultClientProvider;
    private final String endpoint;
    private final KeyVaultSecretProvider keyVaultSecretProvider;
    private final SecretClientBuilderFactory secretClientFactory;
    private final boolean credentialConfigured;
    private final int timeout;

    public AppConfigurationSecretClientManager(String endpoint, SecretClientCustomizer keyVaultClientProvider, KeyVaultSecretProvider keyVaultSecretProvider, SecretClientBuilderFactory secretClientFactory, boolean credentialConfigured, int timeout) {
        this.endpoint = endpoint;
        this.keyVaultClientProvider = keyVaultClientProvider;
        this.keyVaultSecretProvider = keyVaultSecretProvider;
        this.secretClientFactory = secretClientFactory;
        this.credentialConfigured = credentialConfigured;
        this.timeout = timeout;
    }

    AppConfigurationSecretClientManager build() {
        SecretClientBuilder builder = (SecretClientBuilder)this.secretClientFactory.build();
        if (!this.credentialConfigured) {
            builder.credential((TokenCredential)new ManagedIdentityCredentialBuilder().build());
        }
        builder.vaultUrl(this.endpoint);
        if (this.keyVaultClientProvider != null) {
            this.keyVaultClientProvider.customize(builder, this.endpoint);
        }
        this.secretClient = builder.buildAsyncClient();
        return this;
    }

    public KeyVaultSecret getSecret(URI secretIdentifier) {
        String secret;
        String version;
        String[] tokens;
        if (this.secretClient == null) {
            this.build();
        }
        String name = (tokens = secretIdentifier.getPath().split("/")).length >= 3 ? tokens[2] : null;
        String string = version = tokens.length >= 4 ? tokens[3] : null;
        if (this.keyVaultSecretProvider != null && StringUtils.hasText((String)(secret = this.keyVaultSecretProvider.getSecret(secretIdentifier.getRawPath())))) {
            return new KeyVaultSecret(name, secret);
        }
        return (KeyVaultSecret)this.secretClient.getSecret(name, version).block(Duration.ofSeconds(this.timeout));
    }
}

