/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation.properties;

import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClientsBuilder;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.AppConfigurationKeyValueSelector;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.AppConfigurationStoreMonitoring;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.FeatureFlagStore;
import jakarta.annotation.PostConstruct;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.StringUtils;

public final class ConfigStore {
    private static final String DEFAULT_KEYS = "/application/";
    private String endpoint = "";
    private List<String> endpoints = new ArrayList<String>();
    private String connectionString;
    private List<String> connectionStrings = new ArrayList<String>();
    private List<AppConfigurationKeyValueSelector> selects = new ArrayList<AppConfigurationKeyValueSelector>();
    private boolean failFast = true;
    private FeatureFlagStore featureFlags = new FeatureFlagStore();
    private boolean enabled = true;
    private AppConfigurationStoreMonitoring monitoring = new AppConfigurationStoreMonitoring();
    private List<String> trimKeyPrefix;
    private boolean replicaDiscoveryEnabled = true;

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public List<String> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List<String> endpoints) {
        this.endpoints = endpoints;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public List<String> getConnectionStrings() {
        return this.connectionStrings;
    }

    public void setConnectionStrings(List<String> connectionStrings) {
        this.connectionStrings = connectionStrings;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<AppConfigurationKeyValueSelector> getSelects() {
        return this.selects;
    }

    public void setSelects(List<AppConfigurationKeyValueSelector> selects) {
        this.selects = selects;
    }

    public AppConfigurationStoreMonitoring getMonitoring() {
        return this.monitoring;
    }

    public void setMonitoring(AppConfigurationStoreMonitoring monitoring) {
        this.monitoring = monitoring;
    }

    public FeatureFlagStore getFeatureFlags() {
        return this.featureFlags;
    }

    public void setFeatureFlags(FeatureFlagStore featureFlags) {
        this.featureFlags = featureFlags;
    }

    public boolean containsEndpoint(String endpoint) {
        if (this.endpoint.startsWith(endpoint)) {
            return true;
        }
        return this.endpoints.stream().anyMatch(storeEndpoint -> storeEndpoint.startsWith(endpoint));
    }

    public List<String> getTrimKeyPrefix() {
        return this.trimKeyPrefix;
    }

    public void setTrimKeyPrefix(List<String> trimKeyPrefix) {
        this.trimKeyPrefix = trimKeyPrefix;
    }

    public boolean isReplicaDiscoveryEnabled() {
        return this.replicaDiscoveryEnabled;
    }

    public void setReplicaDiscoveryEnabled(boolean replicaDiscoveryEnabled) {
        this.replicaDiscoveryEnabled = replicaDiscoveryEnabled;
    }

    @PostConstruct
    public void validateAndInit() {
        if (this.selects.isEmpty()) {
            this.selects.add(new AppConfigurationKeyValueSelector().setKeyFilter(DEFAULT_KEYS));
        }
        for (AppConfigurationKeyValueSelector selectedKeys : this.selects) {
            selectedKeys.validateAndInit();
        }
        if (StringUtils.hasText((String)this.connectionString)) {
            String endpoint = AppConfigurationReplicaClientsBuilder.getEndpointFromConnectionString(this.connectionString);
            try {
                new URI(endpoint);
                this.endpoint = endpoint;
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Endpoint in connection string is not a valid URI.", e);
            }
        } else if (this.connectionStrings.size() > 0) {
            for (String connection : this.connectionStrings) {
                String endpoint = AppConfigurationReplicaClientsBuilder.getEndpointFromConnectionString(connection);
                try {
                    new URI(endpoint).toURL();
                    if (StringUtils.hasText((String)this.endpoint)) continue;
                    this.endpoint = endpoint;
                }
                catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
                    throw new IllegalStateException("Endpoint in connection string is not a valid URI.", e);
                }
            }
        } else if (this.endpoints.size() > 0) {
            this.endpoint = this.endpoints.get(0);
        }
        this.monitoring.validateAndInit();
        this.featureFlags.validateAndInit();
    }
}

