/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation.properties;

import java.time.Instant;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="spring.cloud.appconfiguration")
public class AppConfigurationProviderProperties {
    public static final String CONFIG_PREFIX = "spring.cloud.appconfiguration";
    private static final Instant START_DATE = Instant.now();
    @Value(value="${version:1.0}")
    private String version;
    @Value(value="${maxRetries:2}")
    private int maxRetries;
    @Value(value="${maxRetryTime:60}")
    private int maxRetryTime;
    @Value(value="${prekillTime:5}")
    private int prekillTime;
    @Value(value="${defaultMinBackoff:30}")
    private Long defaultMinBackoff;
    @Value(value="${defaultMaxBackoff:600}")
    private Long defaultMaxBackoff;

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String apiVersion) {
        this.version = apiVersion;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public int getMaxRetryTime() {
        return this.maxRetryTime;
    }

    public void setMaxRetryTime(int maxRetryTime) {
        this.maxRetryTime = maxRetryTime;
    }

    public int getPrekillTime() {
        return this.prekillTime;
    }

    public void setPrekillTime(int prekillTime) {
        this.prekillTime = prekillTime;
    }

    public Instant getStartDate() {
        return START_DATE;
    }

    public Long getDefaultMinBackoff() {
        return this.defaultMinBackoff;
    }

    public void setDefaultMinBackoff(Long defaultMinBackoff) {
        this.defaultMinBackoff = defaultMinBackoff;
    }

    public Long getDefaultMaxBackoff() {
        return this.defaultMaxBackoff;
    }

    public void setDefaultMaxBackoff(Long defaultMaxBackoff) {
        this.defaultMaxBackoff = defaultMaxBackoff;
    }

    @PostConstruct
    public void validateAndInit() {
        Assert.hasLength((String)this.version, (String)"A version of app configuration should be set.");
        Assert.notNull((Object)this.maxRetries, (String)"A number of max retries has to be configured.");
        Assert.notNull((Object)this.maxRetryTime, (String)"A max retry value needs to be configured");
        Assert.notNull((Object)this.prekillTime, (String)"A preKill time value needs to be configured.");
        Assert.notNull((Object)this.defaultMinBackoff, (String)"A default minimum backoff time value needs to be set.");
        Assert.notNull((Object)this.defaultMaxBackoff, (String)"A default max backoff time value needs to be set.");
    }
}

