/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.FeatureFlagConfigurationSetting;
import com.azure.data.appconfiguration.models.FeatureFlagFilter;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationPropertySource;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClient;
import com.azure.spring.cloud.appconfiguration.config.implementation.feature.entity.Feature;
import com.azure.spring.cloud.appconfiguration.config.implementation.http.policy.TracingInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.util.StringUtils;

class AppConfigurationFeatureManagementPropertySource
extends AppConfigurationPropertySource {
    private static final ObjectMapper CASE_INSENSITIVE_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).build();
    private final String keyFilter;
    private final String[] labelFilter;

    AppConfigurationFeatureManagementPropertySource(String originEndpoint, AppConfigurationReplicaClient replicaClient, String keyFilter, String[] labelFilter) {
        super("FM_" + originEndpoint + "/" + AppConfigurationFeatureManagementPropertySource.getLabelName(labelFilter), replicaClient);
        this.keyFilter = keyFilter;
        this.labelFilter = labelFilter;
    }

    @Override
    public void initProperties(List<String> trim) {
        SettingSelector settingSelector = new SettingSelector();
        String keyFilter = ".appconfig.featureflag/*";
        if (StringUtils.hasText((String)this.keyFilter)) {
            keyFilter = ".appconfig.featureflag/" + this.keyFilter;
        }
        settingSelector.setKeyFilter(keyFilter);
        List<String> labels = Arrays.asList(this.labelFilter);
        Collections.reverse(labels);
        for (String label : labels) {
            settingSelector.setLabelFilter(label);
            List<ConfigurationSetting> features = this.replicaClient.listSettings(settingSelector);
            for (ConfigurationSetting setting : features) {
                if (!(setting instanceof FeatureFlagConfigurationSetting) || !"application/vnd.microsoft.appconfig.ff+json;charset=utf-8".equals(setting.getContentType())) continue;
                this.processFeatureFlag(null, (FeatureFlagConfigurationSetting)setting, null);
            }
        }
    }

    List<ConfigurationSetting> getFeatureFlagSettings() {
        return this.featureConfigurationSettings;
    }

    protected void processFeatureFlag(String key, FeatureFlagConfigurationSetting setting, List<String> trimStrings) {
        TracingInfo tracing = this.replicaClient.getTracingInfo();
        this.featureConfigurationSettings.add(setting);
        FeatureFlagConfigurationSetting featureFlag = setting;
        String configName = "feature-management." + setting.getKey().trim().substring(".appconfig.featureflag/".length());
        AppConfigurationFeatureManagementPropertySource.updateTelemetry(featureFlag, tracing);
        this.properties.put(configName, AppConfigurationFeatureManagementPropertySource.createFeature(featureFlag));
    }

    protected static Object createFeature(FeatureFlagConfigurationSetting item) {
        String key = AppConfigurationFeatureManagementPropertySource.getFeatureSimpleName((ConfigurationSetting)item);
        String requirementType = "Any";
        try {
            JsonNode node = CASE_INSENSITIVE_MAPPER.readTree(item.getValue());
            JsonNode conditions = node.get("conditions");
            if (conditions != null && conditions.get("requirement_type") != null) {
                requirementType = conditions.get("requirement_type").asText();
            }
        }
        catch (JsonProcessingException node) {
            // empty catch block
        }
        Feature feature = new Feature(key, item, requirementType);
        Map<Integer, FeatureFlagFilter> featureEnabledFor = feature.getEnabledFor();
        if (featureEnabledFor.size() == 0 && item.isEnabled()) {
            return true;
        }
        if (!item.isEnabled()) {
            return false;
        }
        for (int filter = 0; filter < feature.getEnabledFor().size(); ++filter) {
            FeatureFlagFilter featureFilterEvaluationContext = featureEnabledFor.get(filter);
            Map parameters = featureFilterEvaluationContext.getParameters();
            if (parameters == null || !"targetingFilter".equals(featureEnabledFor.get(filter).getName())) continue;
            Object audienceObject = parameters.get("Audience");
            if (audienceObject != null) {
                parameters = (Map)audienceObject;
            }
            List<Object> users = AppConfigurationFeatureManagementPropertySource.convertToListOrEmptyList(parameters, "Users");
            List<Object> groupRollouts = AppConfigurationFeatureManagementPropertySource.convertToListOrEmptyList(parameters, "Groups");
            AppConfigurationFeatureManagementPropertySource.switchKeyValues(parameters, "Users", "users", AppConfigurationFeatureManagementPropertySource.mapValuesByIndex(users));
            AppConfigurationFeatureManagementPropertySource.switchKeyValues(parameters, "Groups", "groups", AppConfigurationFeatureManagementPropertySource.mapValuesByIndex(groupRollouts));
            AppConfigurationFeatureManagementPropertySource.switchKeyValues(parameters, "DefaultRolloutPercentage", "defaultRolloutPercentage", parameters.get("DefaultRolloutPercentage"));
            featureFilterEvaluationContext.setParameters(parameters);
            featureEnabledFor.put(filter, featureFilterEvaluationContext);
            feature.setEnabledFor(featureEnabledFor);
        }
        return feature;
    }

    protected static void updateTelemetry(FeatureFlagConfigurationSetting featureFlag, TracingInfo tracing) {
        for (FeatureFlagFilter filter : featureFlag.getClientFilters()) {
            tracing.getFeatureFlagTracing().updateFeatureFilterTelemetry(filter.getName());
        }
    }

    private static String getFeatureSimpleName(ConfigurationSetting setting) {
        return setting.getKey().trim().substring(".appconfig.featureflag/".length());
    }

    private static Map<String, Object> mapValuesByIndex(List<Object> users) {
        return IntStream.range(0, users.size()).boxed().collect(Collectors.toMap(String::valueOf, users::get));
    }

    private static void switchKeyValues(Map<String, Object> parameters, String oldKey, String newKey, Object value) {
        parameters.put(newKey, value);
        parameters.remove(oldKey);
    }

    private static List<Object> convertToListOrEmptyList(Map<String, Object> parameters, String key) {
        List listObjects = (List)CASE_INSENSITIVE_MAPPER.convertValue(parameters.get(key), (TypeReference)new TypeReference<List<Object>>(){});
        return listObjects == null ? Collections.emptyList() : listObjects;
    }
}

