/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.actuator.cosmos;

import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.models.CosmosDatabaseResponse;
import com.azure.spring.cloud.actuator.implementation.util.ActuateConstants;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.util.Assert;

public class CosmosHealthIndicator
extends AbstractHealthIndicator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CosmosHealthIndicator.class);
    private final CosmosAsyncClient cosmosAsyncClient;
    private final String database;
    private final String endpoint;
    private Duration timeout = ActuateConstants.DEFAULT_HEALTH_CHECK_TIMEOUT;

    public CosmosHealthIndicator(CosmosAsyncClient cosmosAsyncClient, String database, String endpoint) {
        super("Cosmos health check failed");
        Assert.notNull((Object)cosmosAsyncClient, (String)"CosmosClient must not be null");
        this.cosmosAsyncClient = cosmosAsyncClient;
        this.database = database;
        this.endpoint = endpoint;
    }

    protected void doHealthCheck(Health.Builder builder) {
        if (this.database == null) {
            builder.status(Status.UNKNOWN).withDetail("Database not configured", (Object)"The option of `spring.cloud.azure.cosmos.database` is not configured!");
            return;
        }
        CosmosDatabaseResponse response = (CosmosDatabaseResponse)this.cosmosAsyncClient.getDatabase(this.database).read().block(this.timeout);
        if (response == null) {
            throw new RuntimeException("Error occurred checking the database!");
        }
        LOGGER.info("The health indicator cost {} RUs, endpoint: {}, database: {}", new Object[]{response.getRequestCharge(), this.endpoint, this.database});
        builder.up().withDetail("database", (Object)this.database);
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }
}

