/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.actuator.autoconfigure.implementation.keyvault;

import com.azure.security.keyvault.certificates.CertificateAsyncClient;
import com.azure.spring.cloud.actuator.implementation.keyvault.KeyVaultCertificateHealthIndicator;
import com.azure.spring.cloud.autoconfigure.implementation.keyvault.certificates.AzureKeyVaultCertificateAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={CertificateAsyncClient.class, HealthIndicator.class})
@ConditionalOnBean(value={CertificateAsyncClient.class})
@AutoConfigureAfter(value={AzureKeyVaultCertificateAutoConfiguration.class})
@ConditionalOnEnabledHealthIndicator(value="azure-keyvault-certificate")
public class KeyVaultCertificateHealthConfiguration {
    @Bean
    KeyVaultCertificateHealthIndicator keyVaultCertificateHealthIndicator(CertificateAsyncClient certificateAsyncClient) {
        return new KeyVaultCertificateHealthIndicator(certificateAsyncClient);
    }
}

