/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.actuator.autoconfigure.keyvault;

import com.azure.security.keyvault.secrets.SecretAsyncClient;
import com.azure.spring.cloud.actuator.keyvault.KeyVaultSecretHealthIndicator;
import com.azure.spring.cloud.autoconfigure.keyvault.secrets.AzureKeyVaultSecretAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={SecretAsyncClient.class, HealthIndicator.class})
@ConditionalOnBean(value={SecretAsyncClient.class})
@AutoConfigureAfter(value={AzureKeyVaultSecretAutoConfiguration.class})
@ConditionalOnEnabledHealthIndicator(value="azure-keyvault-secret")
public class KeyVaultSecretHealthConfiguration {
    @Bean
    KeyVaultSecretHealthIndicator keyVaultSecretHealthIndicator(SecretAsyncClient secretAsyncClient) {
        return new KeyVaultSecretHealthIndicator(secretAsyncClient);
    }
}

