/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.integration.eventhub.support;

import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.models.EventContext;
import com.azure.messaging.eventhubs.models.PartitionContext;
import com.azure.spring.integration.core.api.CheckpointConfig;
import com.azure.spring.integration.core.api.CheckpointMode;
import com.azure.spring.integration.core.api.reactor.AzureCheckpointer;
import com.azure.spring.integration.eventhub.converter.EventHubMessageConverter;
import com.azure.spring.integration.eventhub.impl.EventHubProcessor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;

public class EventHubProcessorSupport
extends EventHubProcessor {
    public EventHubProcessorSupport(Consumer<Message<?>> consumer, Class<?> payloadType, CheckpointConfig checkpointConfig, EventHubMessageConverter messageConverter) {
        super(consumer, payloadType, checkpointConfig, messageConverter);
    }

    public void onEvent(EventContext context, EventData eventData) {
        PartitionContext partition = context.getPartitionContext();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("azure_raw_partition_id", partition.getPartitionId());
        AzureCheckpointer checkpointer = new AzureCheckpointer(() -> ((EventContext)context).updateCheckpointAsync());
        if (this.checkpointConfig.getCheckpointMode() == CheckpointMode.MANUAL) {
            headers.put("azure_checkpointer", (String)checkpointer);
        }
        this.consumer.accept(this.messageConverter.toMessage(eventData, (Map)new MessageHeaders(headers), this.payloadType));
        this.checkpointManager.onMessage(context, eventData);
    }
}

