/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.eventhub.stream.binder.provisioning;

import com.azure.resourcemanager.eventhubs.models.EventHub;
import com.azure.resourcemanager.eventhubs.models.EventHubNamespace;
import com.azure.spring.cloud.context.core.impl.EventHubConsumerGroupManager;
import com.azure.spring.cloud.context.core.impl.EventHubManager;
import com.azure.spring.cloud.context.core.impl.EventHubNamespaceManager;
import com.azure.spring.cloud.context.core.util.Tuple;
import com.azure.spring.eventhub.stream.binder.provisioning.EventHubChannelProvisioner;
import org.springframework.cloud.stream.provisioning.ProvisioningException;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class EventHubChannelResourceManagerProvisioner
extends EventHubChannelProvisioner {
    private final String namespace;
    private final EventHubNamespaceManager eventHubNamespaceManager;
    private final EventHubManager eventHubManager;
    private final EventHubConsumerGroupManager eventHubConsumerGroupManager;

    public EventHubChannelResourceManagerProvisioner(@NonNull EventHubNamespaceManager eventHubNamespaceManager, @NonNull EventHubManager eventHubManager, @NonNull EventHubConsumerGroupManager eventHubConsumerGroupManager, @NonNull String namespace) {
        Assert.hasText((String)namespace, (String)"The namespace can't be null or empty");
        this.namespace = namespace;
        this.eventHubNamespaceManager = eventHubNamespaceManager;
        this.eventHubManager = eventHubManager;
        this.eventHubConsumerGroupManager = eventHubConsumerGroupManager;
    }

    @Override
    protected void validateOrCreateForConsumer(String name, String group) {
        EventHubNamespace eventHubNamespace = (EventHubNamespace)this.eventHubNamespaceManager.getOrCreate((Object)this.namespace);
        EventHub eventHub = (EventHub)this.eventHubManager.getOrCreate((Object)Tuple.of((Object)eventHubNamespace, (Object)name));
        if (eventHub == null) {
            throw new ProvisioningException(String.format("Event hub with name '%s' in namespace '%s' could not be created", name, this.namespace));
        }
        this.eventHubConsumerGroupManager.getOrCreate((Object)Tuple.of((Object)eventHub, (Object)group));
    }

    @Override
    protected void validateOrCreateForProducer(String name) {
        EventHubNamespace eventHubNamespace = (EventHubNamespace)this.eventHubNamespaceManager.getOrCreate((Object)this.namespace);
        this.eventHubManager.getOrCreate((Object)Tuple.of((Object)eventHubNamespace, (Object)name));
    }
}

