/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.config;

import com.azure.spring.messaging.annotation.AzureMessageListener;
import com.azure.spring.messaging.annotation.AzureMessageListeners;
import com.azure.spring.messaging.config.AzureListenerConfigurer;
import com.azure.spring.messaging.config.AzureListenerEndpointRegistrar;
import com.azure.spring.messaging.config.AzureListenerEndpointRegistry;
import com.azure.spring.messaging.container.ListenerContainerFactory;
import com.azure.spring.messaging.endpoint.MethodAzureListenerEndpoint;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.EmbeddedValueResolver;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.lang.Nullable;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public class AzureListenerAnnotationBeanPostProcessor
implements MergedBeanDefinitionPostProcessor,
Ordered,
BeanFactoryAware,
SmartInitializingSingleton {
    public static final String DEFAULT_AZURE_LISTENER_CONTAINER_FACTORY_BEAN_NAME = "azureListenerContainerFactory";
    public static final String DEFAULT_AZURE_LISTENER_ENDPOINT_REGISTRY_BEAN_NAME = "azureListenerEndpointRegistry";
    private static final Logger LOG = LoggerFactory.getLogger(AzureListenerAnnotationBeanPostProcessor.class);
    private final MessageHandlerMethodFactoryAdapter messageHandlerMethodFactory = new MessageHandlerMethodFactoryAdapter();
    private final AzureListenerEndpointRegistrar registrar = new AzureListenerEndpointRegistrar();
    private final AtomicInteger counter = new AtomicInteger();
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));
    private String containerFactoryBeanName = "azureListenerContainerFactory";
    @Nullable
    private AzureListenerEndpointRegistry endpointRegistry;
    @Nullable
    private BeanFactory beanFactory;
    @Nullable
    private StringValueResolver embeddedValueResolver;

    public void setContainerFactoryBeanName(String containerFactoryBeanName) {
        this.containerFactoryBeanName = containerFactoryBeanName;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableBeanFactory) {
            this.embeddedValueResolver = new EmbeddedValueResolver((ConfigurableBeanFactory)beanFactory);
        }
        this.registrar.setBeanFactory(beanFactory);
    }

    public void afterSingletonsInstantiated() {
        MessageHandlerMethodFactory handlerMethodFactory;
        this.nonAnnotatedClasses.clear();
        if (this.beanFactory instanceof ListableBeanFactory) {
            Map beans = ((ListableBeanFactory)this.beanFactory).getBeansOfType(AzureListenerConfigurer.class);
            ArrayList configurers = new ArrayList(beans.values());
            AnnotationAwareOrderComparator.sort(configurers);
            for (AzureListenerConfigurer configurer : configurers) {
                configurer.configureAzureListeners(this.registrar);
            }
        }
        if (this.containerFactoryBeanName != null) {
            this.registrar.setContainerFactoryBeanName(this.containerFactoryBeanName);
        }
        if (this.registrar.getEndpointRegistry() == null) {
            if (this.endpointRegistry == null) {
                Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to find endpoint registry by bean name");
                this.endpointRegistry = (AzureListenerEndpointRegistry)this.beanFactory.getBean(DEFAULT_AZURE_LISTENER_ENDPOINT_REGISTRY_BEAN_NAME, AzureListenerEndpointRegistry.class);
            }
            this.registrar.setEndpointRegistry(this.endpointRegistry);
        }
        if ((handlerMethodFactory = this.registrar.getMessageHandlerMethodFactory()) != null) {
            this.messageHandlerMethodFactory.setMessageHandlerMethodFactory(handlerMethodFactory);
        }
        this.registrar.afterPropertiesSet();
    }

    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class<?> beanType, String beanName) {
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof AopInfrastructureBean || bean instanceof ListenerContainerFactory || bean instanceof AzureListenerEndpointRegistry) {
            return bean;
        }
        Class targetClass = AopProxyUtils.ultimateTargetClass((Object)bean);
        if (!this.nonAnnotatedClasses.contains(targetClass)) {
            Map annotatedMethods = MethodIntrospector.selectMethods((Class)targetClass, method -> {
                Set listenerMethods = AnnotatedElementUtils.getMergedRepeatableAnnotations((AnnotatedElement)method, AzureMessageListener.class, AzureMessageListeners.class);
                return !listenerMethods.isEmpty() ? listenerMethods : null;
            });
            if (annotatedMethods.isEmpty()) {
                this.nonAnnotatedClasses.add(targetClass);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("No @AzureMessageListener annotations found on bean type: " + targetClass);
                }
            } else {
                annotatedMethods.forEach((method, listeners) -> listeners.forEach(listener -> this.processAzureListener((AzureMessageListener)listener, (Method)method, bean)));
                if (LOG.isDebugEnabled()) {
                    LOG.debug(annotatedMethods.size() + " @AzureMessageListener methods processed on bean '" + beanName + "': " + annotatedMethods);
                }
            }
        }
        return bean;
    }

    protected void processAzureListener(AzureMessageListener azureMessageListener, Method mostSpecificMethod, Object bean) {
        Method invocableMethod = AopUtils.selectInvocableMethod((Method)mostSpecificMethod, bean.getClass());
        MethodAzureListenerEndpoint endpoint = this.createMethodAzureListenerEndpoint();
        endpoint.setBean(bean);
        endpoint.setMethod(invocableMethod);
        endpoint.setBeanFactory(this.beanFactory);
        endpoint.setMessageHandlerMethodFactory(this.messageHandlerMethodFactory);
        endpoint.setId(this.getEndpointId(azureMessageListener));
        endpoint.setDestination(this.resolve(azureMessageListener.destination()));
        if (StringUtils.hasText((String)azureMessageListener.group())) {
            endpoint.setGroup(this.resolve(azureMessageListener.group()));
        }
        if (StringUtils.hasText((String)azureMessageListener.concurrency())) {
            endpoint.setConcurrency(this.resolve(azureMessageListener.concurrency()));
        }
        ListenerContainerFactory factory = null;
        String containerFactoryBeanName = this.resolve(azureMessageListener.containerFactory());
        if (StringUtils.hasText((String)containerFactoryBeanName)) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to obtain container factory by bean name");
            try {
                factory = (ListenerContainerFactory)this.beanFactory.getBean(containerFactoryBeanName, ListenerContainerFactory.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new BeanInitializationException("Could not register Azure listener endpoint on [" + mostSpecificMethod + "], no " + ListenerContainerFactory.class.getSimpleName() + " with id '" + containerFactoryBeanName + "' was found in the application context", (Throwable)ex);
            }
        }
        this.registrar.registerEndpoint(endpoint, factory);
    }

    protected MethodAzureListenerEndpoint createMethodAzureListenerEndpoint() {
        return new MethodAzureListenerEndpoint();
    }

    private String getEndpointId(AzureMessageListener azureMessageListener) {
        if (StringUtils.hasText((String)azureMessageListener.id())) {
            String id = this.resolve(azureMessageListener.id());
            return id != null ? id : "";
        }
        return "org.springframework.azure.AzureListenerEndpointContainer#" + this.counter.getAndIncrement();
    }

    @Nullable
    private String resolve(String value) {
        return this.embeddedValueResolver != null ? this.embeddedValueResolver.resolveStringValue(value) : value;
    }

    private class MessageHandlerMethodFactoryAdapter
    implements MessageHandlerMethodFactory {
        @Nullable
        private MessageHandlerMethodFactory messageHandlerMethodFactory;

        private MessageHandlerMethodFactoryAdapter() {
        }

        public InvocableHandlerMethod createInvocableHandlerMethod(Object bean, Method method) {
            return this.getMessageHandlerMethodFactory().createInvocableHandlerMethod(bean, method);
        }

        private MessageHandlerMethodFactory getMessageHandlerMethodFactory() {
            if (this.messageHandlerMethodFactory == null) {
                this.messageHandlerMethodFactory = this.createDefaultAzureHandlerMethodFactory();
            }
            return this.messageHandlerMethodFactory;
        }

        public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
            this.messageHandlerMethodFactory = messageHandlerMethodFactory;
        }

        private MessageHandlerMethodFactory createDefaultAzureHandlerMethodFactory() {
            DefaultMessageHandlerMethodFactory defaultFactory = new DefaultMessageHandlerMethodFactory();
            if (AzureListenerAnnotationBeanPostProcessor.this.beanFactory != null) {
                defaultFactory.setBeanFactory(AzureListenerAnnotationBeanPostProcessor.this.beanFactory);
            }
            defaultFactory.afterPropertiesSet();
            return defaultFactory;
        }
    }
}

