/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.feature.manager.feature.filters;

import com.azure.spring.cloud.feature.manager.FeatureFilter;
import com.azure.spring.cloud.feature.manager.entities.FeatureFilterEvaluationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="PercentageFilter")
public class PercentageFilter
implements FeatureFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PercentageFilter.class);

    @Override
    public boolean evaluate(FeatureFilterEvaluationContext context) {
        String value = (String)context.getParameters().get("Value");
        boolean result = true;
        if (value == null || Double.parseDouble(value) < 0.0) {
            LOGGER.warn("The {} feature filter does not have a valid {} value for feature {}.", new Object[]{this.getClass().getSimpleName(), "Value", context.getName()});
            result = false;
        } else {
            result = Math.random() * 100.0 <= Double.parseDouble(value);
        }
        return result;
    }
}

