/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.context.core.storage;

import com.azure.core.management.AzureEnvironment;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.resourcemanager.storage.StorageManager;
import com.azure.resourcemanager.storage.models.StorageAccount;

public class StorageConnectionStringProvider {
    private final String connectionString;

    public StorageConnectionStringProvider(StorageAccount storageAccount) {
        this.connectionString = StorageConnectionStringProvider.buildConnectionString(storageAccount);
    }

    public StorageConnectionStringProvider(String accountName, String accountKey, AzureEnvironment environment) {
        this.connectionString = ResourceManagerUtils.getStorageConnectionString((String)accountName, (String)accountKey, (AzureEnvironment)environment);
    }

    private static String buildConnectionString(StorageAccount storageAccount) {
        return storageAccount.getKeys().stream().findFirst().map(key -> ResourceManagerUtils.getStorageConnectionString((String)storageAccount.name(), (String)key.value(), (AzureEnvironment)((StorageManager)storageAccount.manager()).environment())).orElseThrow(() -> new RuntimeException("Storage account key is empty."));
    }

    public String getConnectionString() {
        return this.connectionString;
    }
}

