/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.context.core.impl;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.servicebus.models.Queue;
import com.azure.resourcemanager.servicebus.models.ServiceBusNamespace;
import com.azure.spring.cloud.context.core.config.AzureProperties;
import com.azure.spring.cloud.context.core.impl.AzureManager;
import com.azure.spring.cloud.context.core.util.Tuple;

public class ServiceBusQueueManager
extends AzureManager<Queue, Tuple<ServiceBusNamespace, String>> {
    public ServiceBusQueueManager(AzureProperties azureProperties) {
        super(azureProperties);
    }

    @Override
    String getResourceName(Tuple<ServiceBusNamespace, String> key) {
        return key.getSecond();
    }

    @Override
    String getResourceType() {
        return Queue.class.getSimpleName();
    }

    @Override
    public Queue internalGet(Tuple<ServiceBusNamespace, String> namespaceAndName) {
        try {
            return (Queue)namespaceAndName.getFirst().queues().getByName(namespaceAndName.getSecond());
        }
        catch (ManagementException e) {
            if (e.getResponse().getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public Queue internalCreate(Tuple<ServiceBusNamespace, String> namespaceAndName) {
        return (Queue)((Queue.DefinitionStages.Blank)namespaceAndName.getFirst().queues().define(namespaceAndName.getSecond())).create();
    }
}

