/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.context.core.impl;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.redis.models.RedisCache;
import com.azure.spring.cloud.context.core.config.AzureProperties;
import com.azure.spring.cloud.context.core.impl.AzureManager;

public class RedisCacheManager
extends AzureManager<RedisCache, String> {
    private final AzureResourceManager azureResourceManager;

    public RedisCacheManager(AzureResourceManager azureResourceManager, AzureProperties azureProperties) {
        super(azureProperties);
        this.azureResourceManager = azureResourceManager;
    }

    @Override
    String getResourceName(String key) {
        return key;
    }

    @Override
    String getResourceType() {
        return RedisCache.class.getSimpleName();
    }

    @Override
    public RedisCache internalGet(String name) {
        try {
            return (RedisCache)this.azureResourceManager.redisCaches().getByResourceGroup(this.resourceGroup, name);
        }
        catch (ManagementException e) {
            if (e.getResponse().getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public RedisCache internalCreate(String name) {
        return (RedisCache)((RedisCache.DefinitionStages.WithSku)((RedisCache.DefinitionStages.WithGroup)((RedisCache.DefinitionStages.Blank)this.azureResourceManager.redisCaches().define(name)).withRegion(this.region)).withExistingResourceGroup(this.resourceGroup)).withBasicSku().create();
    }
}

