/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.context.core.impl;

import com.azure.core.management.exception.ManagementException;
import com.azure.spring.cloud.context.core.api.ResourceManager;
import com.azure.spring.cloud.context.core.config.AzureProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.StopWatch;

public abstract class AzureManager<T, K>
implements ResourceManager<T, K> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureManager.class);
    private final AzureProperties azureProperties;
    protected final String resourceGroup;
    protected final String region;

    public AzureManager(@NonNull AzureProperties azureProperties) {
        this.azureProperties = azureProperties;
        this.resourceGroup = azureProperties.getResourceGroup();
        this.region = azureProperties.getRegion();
    }

    @Override
    public boolean exists(K key) {
        return this.get(key) != null;
    }

    @Override
    public T get(K key) {
        T t;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String resourceType = this.getResourceType();
        String name = this.getResourceName(key);
        try {
            LOGGER.info("Fetching {} with name '{}' ...", (Object)resourceType, (Object)name);
            t = this.internalGet(key);
        }
        catch (ManagementException e) {
            try {
                LOGGER.error("Fetching {} with name '{}' failed due to: {}", new Object[]{resourceType, name, e.toString()});
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                stopWatch.stop();
                LOGGER.info("Fetching {} with name '{}' finished in {} seconds", new Object[]{resourceType, name, stopWatch.getTotalTimeMillis() / 1000L});
                throw throwable;
            }
        }
        stopWatch.stop();
        LOGGER.info("Fetching {} with name '{}' finished in {} seconds", new Object[]{resourceType, name, stopWatch.getTotalTimeMillis() / 1000L});
        return t;
    }

    @Override
    public T create(K key) {
        T t;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String resourceType = this.getResourceType();
        String name = this.getResourceName(key);
        try {
            LOGGER.info("Creating {} with name '{}' ...", (Object)resourceType, (Object)name);
            t = this.internalCreate(key);
        }
        catch (ManagementException e) {
            try {
                LOGGER.error("Creating {} with name '{}' failed due to: {}", new Object[]{resourceType, name, e.toString()});
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                stopWatch.stop();
                LOGGER.info("Creating {} with name '{}' finished in {} seconds", new Object[]{this.getResourceType(), name, stopWatch.getTotalTimeMillis() / 1000L});
                throw throwable;
            }
        }
        stopWatch.stop();
        LOGGER.info("Creating {} with name '{}' finished in {} seconds", new Object[]{this.getResourceType(), name, stopWatch.getTotalTimeMillis() / 1000L});
        return t;
    }

    @Override
    public T getOrCreate(K key) {
        T result = this.get(key);
        if (result != null) {
            return result;
        }
        if (!this.azureProperties.isAutoCreateResources()) {
            String message = String.format("%s with name '%s' not existed.", this.getResourceType(), this.getResourceName(key));
            LOGGER.warn(message);
            String enable = "If you want to enable automatic resource creation. Please set spring.cloud.azure.auto-create-resources=true";
            throw new IllegalArgumentException(message + enable);
        }
        return this.create(key);
    }

    abstract String getResourceName(K var1);

    abstract String getResourceType();

    abstract T internalGet(K var1);

    abstract T internalCreate(K var1);
}

