/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.context;

import com.azure.core.credential.TokenCredential;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.spring.cloud.autoconfigure.telemetry.SubscriptionSupplier;
import com.azure.spring.cloud.context.core.config.AzureProperties;
import com.azure.spring.identity.DefaultSpringCredentialBuilder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@EnableConfigurationProperties(value={AzureProperties.class})
@ConditionalOnClass(value={AzureResourceManager.class})
@ConditionalOnProperty(prefix="spring.cloud.azure", value={"resource-group"})
public class AzureContextAutoConfiguration {
    private static final String PROJECT_VERSION = AzureContextAutoConfiguration.class.getPackage().getImplementationVersion();
    private static final String SPRING_CLOUD_USER_AGENT = "spring-cloud-azure/" + PROJECT_VERSION;

    @Bean
    @ConditionalOnMissingBean
    public AzureResourceManager azureResourceManager(TokenCredential credential, AzureProfile profile) {
        return AzureResourceManager.configure().authenticate(credential, profile).withDefaultSubscription();
    }

    @Bean
    @ConditionalOnMissingBean
    public AzureProfile azureProfile(AzureProperties azureProperties) {
        return new AzureProfile(azureProperties.getTenantId(), azureProperties.getSubscriptionId(), azureProperties.getEnvironment().getAzureEnvironment());
    }

    @Bean
    @ConditionalOnMissingBean
    public TokenCredential credential(Environment environment) {
        return ((DefaultSpringCredentialBuilder)new DefaultSpringCredentialBuilder().environment(environment)).alternativePrefix("spring.cloud.azure").build();
    }

    @Bean
    @ConditionalOnBean(value={AzureResourceManager.class})
    public SubscriptionSupplier subscriptionSupplier(AzureResourceManager azureResourceManager) {
        return () -> ((AzureResourceManager)azureResourceManager).subscriptionId();
    }
}

