/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.autoconfigure.storage;

import com.azure.spring.autoconfigure.storage.StorageAutoConfiguration;
import com.azure.spring.autoconfigure.storage.actuator.BlobStorageHealthIndicator;
import com.azure.spring.autoconfigure.storage.actuator.FileStorageHealthIndicator;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.file.share.ShareServiceClientBuilder;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@ConditionalOnClass(value={BlobServiceClientBuilder.class, ShareServiceClientBuilder.class, HealthIndicator.class})
@PropertySource(value={"classpath:/azure-spring-actuator.properties"})
@AutoConfigureAfter(value={StorageAutoConfiguration.class})
public class StorageHealthConfiguration {
    @Bean
    @ConditionalOnEnabledHealthIndicator(value="azure-storage")
    @ConditionalOnBean(value={BlobServiceClientBuilder.class})
    public BlobStorageHealthIndicator blobStorageHealthIndicator(BlobServiceClientBuilder blobServiceClientBuilder) {
        return new BlobStorageHealthIndicator(blobServiceClientBuilder);
    }

    @Bean
    @ConditionalOnEnabledHealthIndicator(value="azure-storage")
    @ConditionalOnBean(value={ShareServiceClientBuilder.class})
    public FileStorageHealthIndicator fileStorageHealthIndicator(ShareServiceClientBuilder shareServiceClientBuilder) {
        return new FileStorageHealthIndicator(shareServiceClientBuilder);
    }
}

