/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.aad.webapi.validator;

import com.azure.spring.aad.webapi.validator.AADJwtClaimValidator;
import java.util.function.Predicate;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.Assert;

public class AADJwtIssuerValidator
implements OAuth2TokenValidator<Jwt> {
    private static final String LOGIN_MICROSOFT_ONLINE_ISSUER = "https://login.microsoftonline.com/";
    private static final String STS_WINDOWS_ISSUER = "https://sts.windows.net/";
    private static final String STS_CHINA_CLOUD_API_ISSUER = "https://sts.chinacloudapi.cn/";
    private final AADJwtClaimValidator<String> validator = new AADJwtClaimValidator<String>("iss", this.validIssuer());

    private Predicate<String> validIssuer() {
        return iss -> {
            if (iss == null) {
                return false;
            }
            return iss.startsWith(LOGIN_MICROSOFT_ONLINE_ISSUER) || iss.startsWith(STS_WINDOWS_ISSUER) || iss.startsWith(STS_CHINA_CLOUD_API_ISSUER);
        };
    }

    public OAuth2TokenValidatorResult validate(Jwt token) {
        Assert.notNull((Object)token, (String)"token cannot be null");
        return this.validator.validate(token);
    }
}

