/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.aad.webapi;

import com.azure.spring.aad.AADAuthorizationGrantType;
import com.azure.spring.aad.AADAuthorizationServerEndpoints;
import com.azure.spring.aad.webapi.AADOBOOAuth2AuthorizedClientProvider;
import com.azure.spring.aad.webapp.AuthorizationClientProperties;
import com.azure.spring.autoconfigure.aad.AADAuthenticationProperties;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.AuthenticatedPrincipalOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.OAuth2LoginAuthenticationFilter;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken;

@Configuration(proxyBeanMethods=false)
@ConditionalOnResource(resources={"classpath:aad.enable.config"})
@EnableConfigurationProperties(value={AADAuthenticationProperties.class})
@ConditionalOnClass(value={BearerTokenAuthenticationToken.class, OAuth2LoginAuthenticationFilter.class})
@ConditionalOnProperty(prefix="azure.activedirectory", value={"client-id"})
public class AADResourceServerClientConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AADResourceServerClientConfiguration.class);
    @Autowired
    private AADAuthenticationProperties properties;

    @Bean
    OAuth2AuthorizedClientManager authorizedClientManager(ClientRegistrationRepository clients, OAuth2AuthorizedClientRepository authorizedClients) {
        DefaultOAuth2AuthorizedClientManager manager = new DefaultOAuth2AuthorizedClientManager(clients, authorizedClients);
        OAuth2AuthorizedClientProvider authorizedClientProviders = OAuth2AuthorizedClientProviderBuilder.builder().authorizationCode().refreshToken().clientCredentials().password().provider((OAuth2AuthorizedClientProvider)new AADOBOOAuth2AuthorizedClientProvider()).build();
        manager.setAuthorizedClientProvider(authorizedClientProviders);
        return manager;
    }

    @Bean
    @ConditionalOnMissingBean(value={ClientRegistrationRepository.class})
    public ClientRegistrationRepository clientRegistrationRepository() {
        List<ClientRegistration> clients = this.createClients();
        if (clients.isEmpty()) {
            LOGGER.warn("No client registrations are found for AAD Client.");
            return registrationId -> null;
        }
        return new InMemoryClientRegistrationRepository(clients);
    }

    @Bean
    @ConditionalOnMissingBean
    OAuth2AuthorizedClientService authorizedClientService(ClientRegistrationRepository clientRegistrationRepository) {
        return new InMemoryOAuth2AuthorizedClientService(clientRegistrationRepository);
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuth2AuthorizedClientRepository oAuth2AuthorizedClientRepository(OAuth2AuthorizedClientService oAuth2AuthorizedClientService) {
        return new AuthenticatedPrincipalOAuth2AuthorizedClientRepository(oAuth2AuthorizedClientService);
    }

    public List<ClientRegistration> createClients() {
        ArrayList<ClientRegistration> result = new ArrayList<ClientRegistration>();
        for (String id : this.properties.getAuthorizationClients().keySet()) {
            AuthorizationClientProperties authorizationProperties = this.properties.getAuthorizationClients().get(id);
            if (AADAuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)authorizationProperties.getAuthorizationGrantType())) {
                throw new IllegalStateException("Web Api do not support authorization_code grant type. id = " + id + ".");
            }
            if (authorizationProperties.getAuthorizationGrantType() == null || AADAuthorizationGrantType.ON_BEHALF_OF.equals((Object)authorizationProperties.getAuthorizationGrantType())) {
                result.add(this.createOboClientBuilder(id, authorizationProperties));
                continue;
            }
            if (!AADAuthorizationGrantType.CLIENT_CREDENTIALS.equals((Object)authorizationProperties.getAuthorizationGrantType())) continue;
            result.add(this.createWebClientBuilder(id, authorizationProperties));
        }
        return result;
    }

    private ClientRegistration createOboClientBuilder(String id, AuthorizationClientProperties authorizationProperties) {
        ClientRegistration.Builder result = ClientRegistration.withRegistrationId((String)id);
        result.authorizationGrantType(new AuthorizationGrantType(AADAuthorizationGrantType.ON_BEHALF_OF.getValue()));
        result.redirectUri("{baseUrl}/login/oauth2/code/");
        result.clientId(this.properties.getClientId());
        result.clientSecret(this.properties.getClientSecret());
        result.userNameAttributeName(this.properties.getUserNameAttribute());
        AADAuthorizationServerEndpoints endpoints = new AADAuthorizationServerEndpoints(this.properties.getBaseUri(), this.properties.getTenantId());
        result.authorizationUri(endpoints.authorizationEndpoint());
        result.scope(authorizationProperties.getScopes());
        return result.build();
    }

    private ClientRegistration createWebClientBuilder(String id, AuthorizationClientProperties authorizationProperties) {
        ClientRegistration.Builder result = ClientRegistration.withRegistrationId((String)id);
        result.authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS);
        result.clientId(this.properties.getClientId());
        result.clientSecret(this.properties.getClientSecret());
        AADAuthorizationServerEndpoints endpoints = new AADAuthorizationServerEndpoints(this.properties.getBaseUri(), this.properties.getTenantId());
        result.tokenUri(endpoints.tokenEndpoint());
        result.scope(authorizationProperties.getScopes());
        return result.build();
    }
}

