/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.aad.webapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.StringUtils;

public class AADJwtGrantedAuthoritiesConverter
implements Converter<Jwt, Collection<GrantedAuthority>> {
    private static final String DEFAULT_SCP_AUTHORITY_PREFIX = "SCOPE_";
    private static final String DEFAULT_ROLES_AUTHORITY_PREFIX = "APPROLE_";
    private static final Collection<String> WELL_KNOWN_AUTHORITIES_CLAIM_NAMES = Arrays.asList("scp", "roles");

    public Collection<GrantedAuthority> convert(Jwt jwt) {
        ArrayList<GrantedAuthority> grantedAuthorities = new ArrayList<GrantedAuthority>();
        for (String authority : this.getAuthorities(jwt)) {
            grantedAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority(authority));
        }
        return grantedAuthorities;
    }

    private Collection<String> getAuthorities(Jwt jwt) {
        ArrayList<String> authoritiesList = new ArrayList<String>();
        for (String claimName : WELL_KNOWN_AUTHORITIES_CLAIM_NAMES) {
            if (!jwt.containsClaim(claimName).booleanValue()) continue;
            if (jwt.getClaim(claimName) instanceof String) {
                if (!StringUtils.hasText((String)((String)jwt.getClaim(claimName)))) continue;
                authoritiesList.addAll(Arrays.asList(((String)jwt.getClaim(claimName)).split(" ")).stream().map(s -> DEFAULT_SCP_AUTHORITY_PREFIX + s).collect(Collectors.toList()));
                continue;
            }
            if (!(jwt.getClaim(claimName) instanceof Collection)) continue;
            authoritiesList.addAll(((Collection)jwt.getClaim(claimName)).stream().filter(s -> StringUtils.hasText((String)((String)s))).map(s -> DEFAULT_ROLES_AUTHORITY_PREFIX + s).collect(Collectors.toList()));
        }
        return authoritiesList;
    }
}

