/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.autoconfigure.b2c;

import com.azure.spring.aad.AADIssuerJWSKeySelector;
import com.azure.spring.aad.AADTrustedIssuerRepository;
import com.azure.spring.aad.webapi.validator.AADJwtAudienceValidator;
import com.azure.spring.aad.webapi.validator.AADJwtIssuerValidator;
import com.azure.spring.autoconfigure.b2c.AADB2CProperties;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetAwareJWSKeySelector;
import com.nimbusds.jwt.proc.JWTProcessor;
import java.util.ArrayList;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(prefix="azure.activedirectory.b2c", value={"tenant-id"})
@ConditionalOnClass(value={BearerTokenAuthenticationToken.class})
@EnableConfigurationProperties(value={AADB2CProperties.class})
public class AADB2CResourceServerAutoConfiguration {
    private final AADB2CProperties properties;

    public AADB2CResourceServerAutoConfiguration(@NonNull AADB2CProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public AADTrustedIssuerRepository trustedIssuerRepository() {
        return new AADTrustedIssuerRepository(this.properties.getTenantId());
    }

    @Bean
    @ConditionalOnMissingBean
    public JWTClaimsSetAwareJWSKeySelector<SecurityContext> aadIssuerJWSKeySelector(AADTrustedIssuerRepository trustedIssuerRepository) {
        return new AADIssuerJWSKeySelector(trustedIssuerRepository, this.properties.getJwtConnectTimeout(), this.properties.getJwtReadTimeout(), this.properties.getJwtSizeLimit());
    }

    @Bean
    @ConditionalOnMissingBean
    public JWTProcessor<SecurityContext> jwtProcessor(JWTClaimsSetAwareJWSKeySelector<SecurityContext> keySelector) {
        DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
        jwtProcessor.setJWTClaimsSetAwareJWSKeySelector(keySelector);
        return jwtProcessor;
    }

    @Bean
    public JwtDecoder jwtDecoder(JWTProcessor<SecurityContext> jwtProcessor) {
        NimbusJwtDecoder decoder = new NimbusJwtDecoder(jwtProcessor);
        ArrayList<Object> validators = new ArrayList<Object>();
        ArrayList<String> validAudiences = new ArrayList<String>();
        if (!StringUtils.isEmpty((Object)this.properties.getAppIdUri())) {
            validAudiences.add(this.properties.getAppIdUri());
        }
        if (!StringUtils.isEmpty((Object)this.properties.getClientId())) {
            validAudiences.add(this.properties.getClientId());
        }
        if (!validAudiences.isEmpty()) {
            validators.add(new AADJwtAudienceValidator(validAudiences));
        }
        validators.add(new AADJwtIssuerValidator());
        validators.add(new JwtTimestampValidator());
        decoder.setJwtValidator((OAuth2TokenValidator)new DelegatingOAuth2TokenValidator(validators));
        return decoder;
    }
}

