/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.autoconfigure.aad;

import com.azure.spring.aad.AADAuthorizationServerEndpoints;
import com.azure.spring.autoconfigure.aad.AADAppRoleStatelessAuthenticationFilter;
import com.azure.spring.autoconfigure.aad.AADAuthenticationFilter;
import com.azure.spring.autoconfigure.aad.AADAuthenticationProperties;
import com.azure.spring.autoconfigure.aad.UserPrincipalManager;
import com.azure.spring.telemetry.TelemetryData;
import com.azure.spring.telemetry.TelemetrySender;
import com.nimbusds.jose.jwk.source.DefaultJWKSetCache;
import com.nimbusds.jose.jwk.source.JWKSetCache;
import com.nimbusds.jose.util.DefaultResourceRetriever;
import com.nimbusds.jose.util.ResourceRetriever;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ClassUtils;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnResource(resources={"classpath:aad.enable.config"})
@ConditionalOnMissingClass(value={"org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken"})
@ConditionalOnProperty(prefix="azure.activedirectory", value={"client-id"})
@EnableConfigurationProperties(value={AADAuthenticationProperties.class})
public class AADAuthenticationFilterAutoConfiguration {
    public static final String PROPERTY_PREFIX = "azure.activedirectory";
    private static final Logger LOG = LoggerFactory.getLogger(AADAuthenticationProperties.class);
    private final AADAuthenticationProperties properties;
    private final AADAuthorizationServerEndpoints endpoints;

    public AADAuthenticationFilterAutoConfiguration(AADAuthenticationProperties properties) {
        this.properties = properties;
        this.endpoints = new AADAuthorizationServerEndpoints(properties.getBaseUri(), properties.getTenantId());
    }

    @Bean
    @ConditionalOnMissingBean(value={AADAuthenticationFilter.class})
    @ConditionalOnExpression(value="${azure.activedirectory.session-stateless:false} == false")
    @ConditionalOnProperty(prefix="azure.activedirectory", value={"client-id", "client-secret"})
    public AADAuthenticationFilter azureADJwtTokenFilter() {
        LOG.info("AzureADJwtTokenFilter Constructor.");
        return new AADAuthenticationFilter(this.properties, this.endpoints, this.getJWTResourceRetriever(), this.getJWKSetCache());
    }

    @Bean
    @ConditionalOnMissingBean(value={AADAppRoleStatelessAuthenticationFilter.class})
    @ConditionalOnExpression(value="${azure.activedirectory.session-stateless:false} == true")
    @ConditionalOnProperty(prefix="azure.activedirectory", value={"client-id"})
    public AADAppRoleStatelessAuthenticationFilter azureADStatelessAuthFilter(ResourceRetriever resourceRetriever) {
        LOG.info("Creating AzureADStatelessAuthFilter bean.");
        return new AADAppRoleStatelessAuthenticationFilter(new UserPrincipalManager(this.endpoints, this.properties, resourceRetriever, true));
    }

    @Bean
    @ConditionalOnMissingBean(value={ResourceRetriever.class})
    public ResourceRetriever getJWTResourceRetriever() {
        return new DefaultResourceRetriever(this.properties.getJwtConnectTimeout(), this.properties.getJwtReadTimeout(), this.properties.getJwtSizeLimit());
    }

    @Bean
    @ConditionalOnMissingBean(value={JWKSetCache.class})
    public JWKSetCache getJWKSetCache() {
        long lifespan = this.properties.getJwkSetCacheLifespan();
        long refreshTime = this.properties.getJwkSetCacheRefreshTime();
        return new DefaultJWKSetCache(lifespan, refreshTime, TimeUnit.MILLISECONDS);
    }

    @PostConstruct
    private void sendTelemetry() {
        if (this.properties.isAllowTelemetry()) {
            HashMap<String, String> events = new HashMap<String, String>();
            TelemetrySender sender = new TelemetrySender();
            events.put("serviceName", TelemetryData.getClassPackageSimpleName(AADAuthenticationFilterAutoConfiguration.class));
            sender.send(ClassUtils.getUserClass(this.getClass()).getSimpleName(), events);
        }
    }
}

