/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.keyvault;

import com.azure.spring.keyvault.KeyVaultPropertySource;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.Status;
import org.springframework.core.env.ConfigurableEnvironment;

public class KeyVaultHealthIndicator
implements HealthIndicator {
    private final ConfigurableEnvironment environment;

    public KeyVaultHealthIndicator(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    public Health health() {
        KeyVaultPropertySource keyVaultPropertySource = this.environment.getPropertySources().stream().filter(propertySource -> propertySource instanceof KeyVaultPropertySource).map(propertySource -> (KeyVaultPropertySource)((Object)propertySource)).findFirst().orElse(null);
        if (keyVaultPropertySource == null) {
            return Health.status((Status)Status.UNKNOWN).build();
        }
        if (keyVaultPropertySource.isUp()) {
            return Health.status((Status)Status.UP).build();
        }
        return Health.status((Status)Status.DOWN).build();
    }
}

