/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.autoconfigure.storage.actuator;

import com.azure.core.http.rest.Response;
import com.azure.spring.autoconfigure.storage.actuator.Constants;
import com.azure.storage.file.share.ShareServiceAsyncClient;
import com.azure.storage.file.share.ShareServiceClientBuilder;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

public class FileStorageHealthIndicator
implements HealthIndicator {
    private final ShareServiceAsyncClient internalClient;

    public FileStorageHealthIndicator(ShareServiceClientBuilder shareServiceClientBuilder) {
        this.internalClient = shareServiceClientBuilder == null ? null : shareServiceClientBuilder.buildAsyncClient();
    }

    public Health health() {
        Health.Builder healthBuilder = new Health.Builder();
        try {
            healthBuilder.withDetail("URL", (Object)this.internalClient.getFileServiceUrl());
            try {
                Response infoResponse = (Response)this.internalClient.getPropertiesWithResponse().block(Constants.POLL_TIMEOUT);
                if (infoResponse != null) {
                    healthBuilder.up();
                }
            }
            catch (Exception e) {
                healthBuilder.down((Throwable)e);
            }
        }
        catch (Exception e) {
            healthBuilder.status("Could not complete health check.").down((Throwable)e);
        }
        return healthBuilder.build();
    }
}

